package brn.sim.handler;

import java.util.HashMap;
import java.util.Map;

import jist.swans.mac.MacAddress;
import jist.swans.misc.Event;
import jist.swans.net.NetAddress;
import jist.swans.route.AbstractRoute.DuplicateEvent;
import jist.swans.route.AbstractRoute.PacketForwardedEvent;
import jist.swans.trans.TransInterface.TransMessage;
import brn.swans.route.RouteDsrBrnMsg;
import brn.swans.route.RouteDsrBrnMsg.OptionId;
import click.runtime.ClickException;
import click.swans.net.ClickRouter;

public class ClickRouteTracer implements Event.Handler {

  private Map etherToIp = new HashMap();

  private PacketForwardedEvent forwardEvent;

  private DuplicateEvent dupeEvent;

  //private RouteDsrBrnMsg forwardMessage = new RouteDsrBrnMsg();

  public void handle(Event event) {
    ClickRouter.ClickPullEvent ev = (ClickRouter.ClickPullEvent) event;
    ClickRouter router = (ClickRouter) ev.getRouter();
    NetAddress net = router.getAddress();
    for (int i = 0; i < router.getNumInterfaces(); ++i) {
      MacAddress mac = router.getMacAddress(i);
      etherToIp.put(mac, net);
    }

    forwardEvent = new PacketForwardedEvent(net.getId());
    dupeEvent = new DuplicateEvent(net.getId());

    try {
      String forwarded = router.readHandler("meshNode/trace_collector",
          "forwarded");
      decodeString(forwarded, forwardEvent, net);
      String dupe = router.readHandler("meshNode/trace_collector",
          "duplicate");
      decodeString(dupe, dupeEvent, net);
      // TODO: dropped; however, it isn't implemented in click either
    } catch (ClickException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
      return;
    }
  }

  private void decodeString(String message, PacketForwardedEvent event,
      NetAddress net) {
    if (message != null && 0 < message.length()) {
      String[] routes = message.split(";");
      for (int i = 0; i < routes.length; i++) {
        String[] macs = routes[i].split("-");
        MacAddress src = new MacAddress(macs[0]);
        MacAddress dst = new MacAddress(macs[1]);
        MacAddress last = new MacAddress(macs[2]);
        packet(src, dst, last, net, event);
      }
    }
  }

  /**
   *  TODO put working again
   */
  private void packet(MacAddress srcMac, MacAddress dstMac,
      MacAddress lastMac, NetAddress me, PacketForwardedEvent event) {
//    NetAddress src = (NetAddress) etherToIp.get(srcMac);
//    NetAddress dst = (NetAddress) etherToIp.get(dstMac);
//    NetAddress last = (NetAddress) etherToIp.get(lastMac);
//
//    int flowId = TransMessage.determineFlowId(src, dst);
//
//
//    // flowId is -1 if the flow wasn't registered; these are various protocol messages
//    // from inside click and TCP acks and the like. Might still be interesting, but isn't
//    // counted here.
//    if (flowId != -1) {
//      RouteDsrBrnMsg forwardMessage = new RouteDsrBrnMsg(event.getData(), flowId, 0, null );
//      forwardMessage.addOption(new OptionId((short) 0, flowId, 0, null, 0));
//
//      event.handle(forwardMessage, null, last, me);
//    }
  }

}
