package brn.sim.scenario.txdor;

import java.io.IOException;

import brn.sim.builder.RadioBuilder;

import jist.swans.Constants;
import jist.swans.misc.Util;
import click.sim.builder.ClickBuilder;

public class TxDOrClickParams extends TxDOrParams {
  private static final long serialVersionUID = 1L;

  /**
   * Creates default parameters for TxDOR simulation.
   *
   * @return default parameters for TxDOR simulation.
   */
  public static TxDOrClickParams defaultParams(TxDOrClickParams params) {
    params = (TxDOrClickParams) TxDOrParams.defaultParams(params);

    RadioBuilder.NoiseParams radio = (RadioBuilder.NoiseParams) params.node.radio;
    radio.radioType = Constants.MAC_802_11bg; // TODO pure g

    ClickBuilder.MacParams mac = new ClickBuilder.MacParams();
    mac.useAnnos = true;
    mac.useBitRateAnnos = true;
    mac.isStation = false;
    mac.macPromisc = true;
    params.node.mac = mac;

    ClickBuilder.NetParams net = new ClickBuilder.NetParams();
    net.clickfile = "res/click/_sim-main-txdor.click";
    net.netPromisc = false;
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_LINK_PROBE, Constants.NET_PROTOCOL_MCEXOR,
        Constants.NET_PROTOCOL_FLOODING, Constants.NET_PROTOCOL_TCP };
    params.node.net = net;

    params.node.route = null;

    return params;
  }

  public static void main(String[] args) throws IOException {
    TxDOrClickParams params = (TxDOrClickParams)
        defaultParams(new TxDOrClickParams()).setParamsTest();

    // and out
    Util.writeObject("res/config/TxDOrClickParams.xml", params);
  }

  /*
   * (non-Javadoc)
   * @see brn.sim.scenario.txdor.TxDOrParams#setParamsTest()
   */
  public TxDOrParams setParamsTest() {
    TxDOrParams ret = super.setParamsTest();
    dumpNetNam = null; // TODO
    dumpMacNam = null; // TODO
    handlerNetTimeBar = false; // TODO
    return ret;
  }

}
