package click.runtime;


public class HandlerInfo {
  ClickInterface cs;
  public String elementName;
  public String handlerName;
  public boolean canRead;
  public boolean canWrite;

  public HandlerInfo(ClickInterface cs) {
    this(cs, null, null);
  }

  public HandlerInfo(ClickInterface cs, String el) {
    this(cs, el, null);
  }

  public HandlerInfo(ClickInterface cs, String el, String handler) {
    this.cs = cs;
    elementName = el;
    handlerName = handler;
    canRead = canWrite = false;
  }

  public ClickInterface getControl() {
    return cs;
  }

  public String getDescription() {
    if (elementName == null)
      return handlerName;
    else
      return elementName + "." + handlerName;
  }

  public String toString() {
    return handlerName;
  }
}
