package click.runtime;

import jist.swans.misc.Message;
import jist.swans.net.NetMessage;
import click.swans.mac.MacClickMessageFactory;
import click.swans.mac.MacDumbClickMessageFactory;

public class Util {

  private static MacClickMessageFactory clickFactory = new MacClickMessageFactory();
  private static MacDumbClickMessageFactory dumbFactory = new MacDumbClickMessageFactory();
	
	
  public static Message fromBytes(byte[] data, int type, boolean raw) 
      throws ClickException, Message.IllegalFormatException {
    // Unmarshall packet, use raw encoding
    Message msg = null;
    switch (type) {
    case  ClickInterface.SIMCLICK_PTYPE_ETHER:
//      msg = msgFactory.fromBytes(data, 0, true);
//      if (MacClickMessage.ETHER_TYPE_IP != Pickle.arrayToUShort(data, 12)) {
//        log.error("Only ip in ethernet encaped packets supported");
//        return;
//      }
      msg = dumbFactory.fromBytes(data, 0);
      break;
    case  ClickInterface.SIMCLICK_PTYPE_IP:
      msg = new NetMessage.Ip(data, 0);
      break;
    case  ClickInterface.SIMCLICK_PTYPE_WIFI:
      msg = clickFactory.fromBytes(data, 0, raw);
//      msg = MacMessage.fromBytes(data, 0);
      break;
    case  ClickInterface.SIMCLICK_PTYPE_WIFI_EXTRA:
      msg = clickFactory.extraFromBytes(data, 0, raw);
//      msg = new ClickExtraHeader(data, 0);
      break;
    case  ClickInterface.SIMCLICK_PTYPE_UNKNOWN:
    default:
      throw new ClickException("Unknown packet type: " + type);
    }
    
    return msg;
  }

}
