package click.runtime.remote;

public class BrnTestbedNodes {
  
  public static class NodeEntry {
    public int id;
    public String name;
    public String pos;
    public String room;
    public NodeEntry(int id, String name, String pos, String room) {
      this.id = id;
      this.name = name;
      this.pos = pos;
      this.room = room;
    }
  }

  private static NodeEntry[] nodes = new NodeEntry[] {
    new NodeEntry(63, "wgt63", "10,12", "3.325"),
    new NodeEntry(81, "wgt81", "10.5,12", "3.325"),
    new NodeEntry(31, "wgt31", "10,14", "3.326"),
    new NodeEntry(49, "wgt49", "10,20", "3.328"),

    new NodeEntry(41, "wgt41", "5,20", "3.201"),
    new NodeEntry(25, "wgt25", "5,10", "3.206"),

    new NodeEntry(33, "wgt33", "4.5,9.5", "3.106"),
    new NodeEntry(79, "wgt79", "5,7", "3.107"),
    new NodeEntry(80, "wgt80", "4.5,7", "3.107"),

    new NodeEntry(51, "wgt51", "20,6", "4.316"),
    new NodeEntry(52, "wgt52", "14.5,12", "4.307"),
    new NodeEntry(53, "wgt53", "15,20", "4.323"),
    new NodeEntry(54, "wgt54", "20,3", "4.418"),
    new NodeEntry(55, "wgt55", "15,8", "4.410"),

//    new NodeEntry(73, "wgt73", "0,0", "??"), // wrong kernel
//    new NodeEntry(29, "wgt29", "10,11", "3.324??"), // wrong kernel
//    new NodeEntry(44, "wgt44", "5.5,10", "3.206"), // wrong kernel
//    new NodeEntry(42, "wgt42", "4.5,7", "3.107"), // no interface
//    new NodeEntry(32, "wgt32", "5,7", "3.107"), // hardware error
    
    // EDIM nodes
    new NodeEntry(218, "192.168.3.218", "10,11", "3.324"),
    new NodeEntry(234, "192.168.3.234", "10,20", "3.328"),
  };

  public static NodeEntry getNode(int node) {
    for (int i = 0; i < nodes.length; i++)
      if (nodes[i].id == node)
        return nodes[i];
    return null;
  }

  public static NodeEntry getNode(String name) {
    for (int i = 0; i < nodes.length; i++)
      if (nodes[i].name.equals(name))
        return nodes[i];
    return null;
  }

  public static String[] getNodeNames(int[] node) {
    String[] ret = new String[node.length];
    for (int i = 0; i < node.length; i++)
      ret[i] = getNode(node[i]).name;
    return ret;
  }

  public static String[] getNodePositions(int[] node) {
    String[] ret = new String[node.length];
    for (int i = 0; i < node.length; i++)
      ret[i] = getNode(node[i]).pos;
    return ret;
  }

  public static String getNodeRoom(String name) {
    NodeEntry entry = getNode(name);
    if (null != entry)
      return entry.room;
    return "??";
  }


}
