package click.runtime.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import click.runtime.ClickInterface;

import jist.swans.misc.MessageBytes;
import brn.sim.data.dump.WiresharkDump;

/**
 * TODO data contribution wireshark and click remotereceive handler
 * wireshark -> zip -> db
 *
 */
public class DumpHandler implements Closeable {

  private Map<Integer, WiresharkDump> dumpMap;
  private String fileName;
  private int encapType; 

  public DumpHandler(
      String fileName, int encapType) throws IOException {
    dumpMap = new HashMap<Integer, WiresharkDump>();
    this.fileName = fileName;
    this.encapType = encapType;
  }

  /*
   * (non-Javadoc)
   * @see java.io.Closeable#close()
   */
  public void close() throws IOException {
    for (WiresharkDump dump : dumpMap.values()) {
      dump.close();
    }
  }

  public void dump(int ifid, byte[] data, int type, long time) {
    WiresharkDump dump = dumpMap.get(ifid);
    try {
      if (null == dump) {
        int fileType = encapType;
        // TODO translation
//        if (fileType == ClickInterface.SIMCLICK_PTYPE_UNKNOWN)
//          fileType = ;
        dump = new WiresharkDump(fileName + "-" + ifid + ".pcap", fileType);
        dumpMap.put(ifid, dump);
      }
      dump.dump(new MessageBytes(data), time);
    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

}
