package jist.runtime;

import java.lang.reflect.Method;

public class ThreadedEntityRef extends EntityRef {

  public ThreadedEntityRef(EntityRef ref) {
    super(ref.getIndex());
  }

  /*
   * (non-Javadoc)
   * @see jist.runtime.EntityRef#invoke(java.lang.Object, java.lang.reflect.Method, java.lang.Object[])
   */
  public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
  {
    if(Rewriter.isBlockingRuntimeProxy(method))
      throw new JistException("blocking mode not supported", null);

    // schedule a simulation event
    RealtimeController controller;
    if(Main.SINGLE_CONTROLLER)
    {
      controller = (RealtimeController) Controller.activeController;
    }
    else
    {
      controller = (RealtimeController) getController();
    }
    controller.addPendingEvent(method, this, args);

    return null;
  }

}
