#
# Set some general simulation parameters
#

#
# Unity gain, omnidirectional antennas, centered 1.5m above each node.
# These values are lifted from the ns-2 sample files.
#
Antenna/OmniAntenna set X_ 0
Antenna/OmniAntenna set Y_ 0
Antenna/OmniAntenna set Z_ 1.5
Antenna/OmniAntenna set Gt_ 1.0
Antenna/OmniAntenna set Gr_ 1.0

#
# Initialize the SharedMedia interface with parameters to make
# it work like the 914MHz Lucent WaveLAN DSSS radio interface
# These are taken directly from the ns-2 sample files.
#

#DSSS (IEEE802.11b)

Phy/WirelessPhy set CPThresh_ 10.0
#Phy/WirelessPhy set CSThresh_ 5.011872e-12
Phy/WirelessPhy set CSThresh_ 1.559e-11
Phy/WirelessPhy set RXThresh_ 3.28984e-09
#Phy/WirelessPhy set RXThresh_ 3.652e-10
#Phy/WirelessPhy set RXThresh_ 5.82587e-09
#Phy/WirelessPhy set Rb_ 2*1e6
Phy/WirelessPhy set Pt_ 0.281838
#Phy/WirelessPhy set Pt_ 0.031622777


Phy/WirelessPhy set freq_ 2.472e9
Phy/WirelessPhy set L_ 1.0
Phy/WirelessPhy set bandwidth_ 11Mb


Mac/802_11 set SlotTime_          0.000020        ;# 20us
Mac/802_11 set SIFS_              0.000010        ;# 10us
Mac/802_11 set PreambleLength_    144             ;# 144 bit
Mac/802_11 set PLCPHeaderLength_  48              ;# 48 bits
Mac/802_11 set PLCPDataRate_      11.0e6           ;# 1Mbps
Mac/802_11 set dataRate_          54.0e6          ;# 11Mbps
Mac/802_11 set basicRate_         11.0e6           ;# 1Mbps

Mac/802_11 set RTSThreshold_ 3000
Mac/802_11 set ShortRetryLimit_ 7               ;# retransmittions
Mac/802_11 set LongRetryLimit_  4               ;# retransmissions


#COLLISIONWINDOWS MIN 31
#MAX 1023

# 
# Set the size of the playing field and the topography.
#
set xsize  385
set ysize  385
set wtopo	[new Topography]
$wtopo load_flatgrid $xsize $ysize

#
# The network channel, physical layer, MAC, propagation model,
# and antenna model are all standard ns-2.
#  
set netchan	Channel/WirelessChannel
set netphy	Phy/WirelessPhy
set netmac	Mac/802_11
set netprop     Propagation/TwoRayGround
set antenna     Antenna/OmniAntenna

#
# Create a network Channel for the nodes to use. One channel
# per LAN. Also set the propagation model to be used.
#
set wiredchan Channel
set wiredphy Phy/WiredPhy
set wiredmac Mac/802_3

#
# We have to use a special queue and link layer. This is so that
# Click can have control over the network interface packet queue,
# which is vital if we want to play with, e.g. QoS algorithms.
#
set netifq	Queue/ClickQueue
set netll	LL/Ext
LL set delay_			1ms

#
# These are pretty self-explanatory, just the number of nodes
# and when we'll stop.
#

# Note: in the nsclick file, wireless is eth1 and wire is eth0
# Note: SimHeaders must be activated in the click file
# Note: ns2 does not support extra headers
set clickfile   "res/click/meshnode.nsclick"
set nodecount   49
set stoptime    180.0
set clients     1
set xx          7

#
# With nsclick, we have to worry about details like which network
# port to use for communication. This sets the default ports to 5000.
#
Agent/Null set sport_		5000
Agent/Null set dport_		5000

Agent/CBR set sport_		5000
Agent/CBR set dport_		5000

#
# Standard ns-2 stuff here - create the simulator object.
#
Simulator set MacTrace_ ON
set ns_		[new Simulator]

#
# Create and activate trace files.
#
set tracefd     [open "arp_dht\.tr" w]
set namtrace    [open "arp_dht\.nam" w]
$ns_ trace-all $tracefd
$ns_ namtrace-all-wireless $namtrace $xsize $ysize
$ns_ use-newtrace


#
# Create the "god" object. This is another artifact of using
# the mobile node type. We have to have this even though
# we never use it.
#
set god_ [create-god $nodecount]

#
# Tell the simulator to create Click nodes.
#
Simulator set node_factory_ Node/MobileNode/ClickNode

#
# Create a network Channel for the nodes to use. One channel
# per LAN. Also set the propagation model to be used.
#
set chan_1_ [new $netchan]
set prop_ [new $netprop]

#
# In nsclick we have to worry about assigning IP and MAC addresses
# to out network interfaces. Here we generate a list of IP and MAC
# addresses, one per node since we've only got one network interface
# per node in this case. Also note that this scheme only works for
# fewer than 255 nodes, and we aren't worrying about subnet masks.
#
set iptemplate "10.9.0.%d"
set mactemplate "00:03:47:70:89:%0x"
for {set i 0} {$i < $nodecount} {incr i} {
    set node_ip($i) [format $iptemplate [expr $i+1]]
    set node_mac($i) [format $mactemplate [expr $i+1]]
}

set iptemplate_wire "10.9.100.%d"
set mactemplate_wire "00:00:FF:00:00:%0x"
for {set i 0} {$i < $nodecount} {incr i} {
    set node_ip_wire($i) [format $iptemplate_wire [expr $i+1]]
    set node_mac_wire($i) [format $mactemplate_wire [expr $i + 1]]
}

#
# We set the routing protocol to "Empty" so that ns-2 doesn't do
# any packet routing. All of the routing will be done by the
# Click script.
#
$ns_ rtproto Empty

#
# Here is where we actually create all of the nodes.
#
for {set i 0} {$i < $nodecount } {incr i} {
    set node_($i) [$ns_ node]

    #
    # After creating the node, we add one wireless network interface to
    # it. By default, this interface will be named "eth0". If we
    # added a second interface it would be named "eth1", a third
    # "eth2" and so on.
    #
    set wired_chan_($i) [new $wiredchan]
		$node_($i) add-wired-interface $wired_chan_($i) $netll $wiredmac \
			$netifq 1 $wiredphy

    $node_($i) add-interface $chan_1_ $prop_ $netll $netmac \
  	  $netifq 1 $netphy $antenna $wtopo

    #
    # Now configure the interface eth0
    #
    $node_($i) setip "eth0" $node_ip_wire($i)
    $node_($i) setmac "eth0" $node_mac_wire($i)
    #$node_($i) setip "eth1" $node_ip($i)
    $node_($i) setmac "eth1" $node_mac($i)
    $node_($i) setip "tap0" $node_ip($i)

    #
    # Set some node properties
    #
    $node_($i) random-motion 0
    $node_($i) topography $wtopo
    $node_($i) nodetrace $tracefd

    #
    # The node name is used by Click to distinguish information
    # coming from different nodes. For example, a "Print" element
    # prepends this to the printed string so it's clear exactly
    # which node is doing the printing.
    #
    [$node_($i) set classifier_] setnodename "node$i"
    
    #
    # Load the appropriate Click router script for the node.
    # All nodes in this simulation are using the same script,
    # but there's no reason why each node couldn't use a different
    # script.
    #
    [$node_($i) entry] loadclick $clickfile
    
    # configure the dht
    set startup_time_($i) [format "%d" [expr 30000 + 100*$i]]
    [$node_($i) entry] writehandler "MeshNode/dht/dht" "startup_time" $startup_time_($i)
    [$node_($i) entry] writehandler "MeshNode/dht/dht" "fake_arp_for_simulator" "true"
    [$node_($i) entry] writehandler "MeshNode/dht/dht" "subnet_mask" "255.255.252.0"

    # configure arp
    set starttime_($i) [format "%d" [expr 40000 + 100*$i]]
    set count_($i) [format "%d" [expr 10*$clients]]
    set requests_at_once_($i) [format "%d" $clients];
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "debug" "3"
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "start_range" "10.9.0.0"
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "range" "1024"
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "client_start" $starttime_($i)
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "client_interval" "450"
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "count" $count_($i)
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "requests_at_once" $requests_at_once_($i)
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "timeout" "5000"
    [$node_($i) entry] writehandler "MeshNode/local_device/arpclient" "active" "true"
}

for {set i 0} {$i < $nodecount} {incr i} {
   $ns_ at 0.0 "[$node_($i) entry] runclick"
}

# 
# Define node network traffic. There isn't a whole lot going on
# in this simple test case, we're just going to have the first node
# send packets to the last node, starting at 1 second, and ending at 10.
# There are Perl scripts available to automatically generate network
# traffic.
#


#
# Start transmitting at $startxmittime, $xmitrate packets per second.
#
set startxmittime 0
set xmitrate 4
set xmitinterval 0.25
set packetsize 64


for {set i 0} {$i < $nodecount} {incr i} {
    $node_($i) set X_ [expr $i % $xx * 55 ]
    $node_($i) set Y_ [expr $i / $xx * 55 ]
    $node_($i) set Z_ 0
    $node_($i) label $node_mac($i).brn
}

#
# This sizes the nodes for use in nam. Currently, the trace files
# produced by nsclick don't really work in nam.
#
for {set i 0} {$i < $nodecount} {incr i} {
    $ns_ initial_node_pos $node_($i) 20
}

#
# Stop the simulation
#
$ns_ at  $stoptime.000000001 "puts \"NS EXITING...\" ; $ns_ halt"

# [$node_(2) entry] writehandler "MeshNode/dht/dht" "debug" "2"
# [$node_(2) entry] writehandler "MeshNode/link_stat" "debug" "2"
# 
# puts [[$node_(2) entry] readhandler "MeshNode/dht/dht" "routing_info"]
# $ns_ at  5.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/dht/dht routing_info\]\""
# $ns_ at  5.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/link_stat bcast_stats\]\""
# 
# $ns_ at  10.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/dht/dht routing_info\]\""
# $ns_ at  10.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/link_stat bcast_stats\]\""
# 
# $ns_ at  20.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/dht/dht routing_info\]\""
# $ns_ at  20.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/link_stat bcast_stats\]\""
# 
# $ns_ at  30.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/dht/dht routing_info\]\""
# $ns_ at  30.0 "puts \"\[\[$node_(2) entry\] readhandler MeshNode/link_stat bcast_stats\]\""


#
# Let nam know that the simulation is done.
#
$ns_ at  $stoptime	"$ns_ nam-end-wireless $stoptime"


puts "Starting Simulation..."
$ns_ run


