package test.click;

import jist.swans.Constants;
import click.runtime.remote.BrnTestbedNodes;
import click.sim.builder.ClickBuilder;
import brn.sim.AbstractDriver;
import brn.sim.AbstractParams;
import brn.sim.BasicDriver;
import brn.sim.DataManager;
import brn.sim.builder.Builder;
import brn.sim.builder.MetricBuilder;
import brn.sim.builder.NodeBuilder;
import brn.sim.builder.NodeBuilder.ExtensibleParams;
import brn.sim.builder.NodeBuilder.NodeParams;
import brn.sim.data.dump.WiresharkDump;

public class RemoteHiddenTest extends AbstractDriver {

  public static void testDump() throws Exception {
    ClickBuilder.NetRemoteParams netParams = new ClickBuilder.NetRemoteParams();
    netParams.hosts = BrnTestbedNodes.getNodeNames(new int[] {63, 49});
    netParams.clickScript = "res/click/r_dump.click";
    netParams.dumpFilePrefix = "dump-node-";
    netParams.pullRemotePackets = true;
    netParams.processRemotePackets = false;
    netParams.collectRemotePacketsAtEnd = false;
    netParams.clickPacketEncap = WiresharkDump.FAKE_DLT_PRISM_HEADER;
    netParams.connectorProperties = ClickBuilder.CONNECTOR_WGT;

    NodeParams nodeParams = new NodeParams();
    nodeParams.radio = null;
    nodeParams.mac = null;
    nodeParams.net = netParams;
    nodeParams.route = null;

    AbstractParams params = new AbstractParams();
    params.nodeNumber = new int[] {netParams.hosts.length};
    params.nodeParams = new NodeBuilder.NodeParams[] {nodeParams};
    params.endTime = 20;

    params.handlerNetLevel = DataManager.LEVEL_ALL;

    BasicDriver test = new BasicDriver();
    test.run(params);
  }

  public AbstractParams getLinkProbeParams(int[] sender, double rate /*pps*/,
      int[] receiver) throws Exception {
    ClickBuilder.NetRemoteParams netParams = new ClickBuilder.NetRemoteParams();
    netParams.hosts = BrnTestbedNodes.getNodeNames(sender);
    netParams.nodePositions = BrnTestbedNodes.getNodePositions(sender);
//  netParams.clickScript = "res/click/r_linkprobe_aligned.click";
    netParams.clickScript = "res/click/r_linkprobe.click";
    netParams.dumpFilePrefix = "dump-node-";
    netParams.pullRemotePackets = true;
    netParams.processRemotePackets = true;
    netParams.collectRemotePacketsAtEnd = false;
    netParams.clickPacketEncap = WiresharkDump.FAKE_DLT_IEEE802_11;
    netParams.connectorProperties = ClickBuilder.CONNECTOR_WGT;
    netParams.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_TCP, Constants.NET_PROTOCOL_LINK_PROBE };

    // metric
    double txRate = rate; //pps
    MetricBuilder.EtxParams metricParams = new MetricBuilder.EtxParams();
    int size = 1500;
    metricParams.probes = new int[] {
        Constants.BANDWIDTH_1Mbps, size,
    };
    metricParams.period = (int)(1000. / txRate);
    metricParams.tau = 1000;
    metricParams.autoStart = true;

    ExtensibleParams senderParams = new ExtensibleParams();
    senderParams.radio = null;
    senderParams.mac = null;
    senderParams.net = netParams;
    senderParams.route = null;
    senderParams.extension = new Builder.Params[] {metricParams};

    ExtensibleParams receiverParams = (ExtensibleParams) senderParams.clone();
    ((MetricBuilder.EtxParams)receiverParams.extension[0]).period = 1000 * 60 * 60;
    ((MetricBuilder.EtxParams)receiverParams.extension[0]).tau = 1000 * 60 * 60;
    ((ClickBuilder.NetRemoteParams)receiverParams.net).hosts = BrnTestbedNodes.getNodeNames(receiver);
    ((ClickBuilder.NetRemoteParams)receiverParams.net).nodePositions = BrnTestbedNodes.getNodePositions(receiver);

    AbstractParams params = new AbstractParams();
    params.nodeNumber = new int[] {sender.length, receiver.length};
    params.nodeParams = new NodeBuilder.NodeParams[] {senderParams, receiverParams};
    params.endTime = 60*1;

    params.handlerTransLevel = DataManager.LEVEL_ALL;
    params.handlerFlowLevel = DataManager.LEVEL_ALL;
    params.handlerNetLevel = DataManager.LEVEL_ALL;
    params.handlerLinkQualityLevel = DataManager.LEVEL_ALL;

    params.db = true;

    return params;
  }

  @Override
  protected void runLocal() {
//  testDump();
    
    AbstractParams params;
    try {
//    int[] hosts = new int[] {63, 49};
      params = getLinkProbeParams(new int[] {81, 51}, 60,
          new int[] {52, 53, 54, 55, 63, 49, 41, 25, 33, 32, 31});
      run(params);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
  
  public static void main(String[] args) throws Throwable {
    RemoteHiddenTest test = new RemoteHiddenTest();
    test.run(args);
  }
}
