/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */


/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * Lots of utility elementclasses. The idea is to overwrite the standard PrintXXX elements.
 */

elementclass Print {
    __REST__ $rest |

  input[0]
  //-> Print($rest)
  -> [0]output;
}

elementclass IPPrint {
    __REST__ $rest |

  input[0]
  //-> IPPrint($rest)
  -> [0]output;
}

elementclass PrintWifi {
    __REST__ $rest |

  input[0]
  //-> PrintWifi($rest)
  -> [0]output;
}

elementclass ARPPrint {
    __REST__ $rest |

  input[0]
  //-> ARPPrint($rest)
  -> [0]output;
}

elementclass DHCPPrint {
    __REST__ $rest |

  input[0]
  //-> DHCPPrint($rest)
  -> [0]output;
}

/**
 * Define the ToDumpWifi as empty class (no dumping). To enable dumping,
 * uncomment the lines below.
 * 
 * For simulation purposes the element class is redefined in simdevices.click
 */
elementclass ToDumpWifi {
  $file_name |
//  dump_wifi  :: ToDump($file_name.pcap, SNAPLEN 3000, ENCAP 802_11);
||
  DUMP $dump_element |
//  input -> ToDumpDlg($dump_element/dump_wifi) -> output;
  input -> output;
}

/**
 * Define the ToDumpEther as empty class (no dumping). o enable dumping,
 * uncomment the lines below.
 * 
 * For simulation purposes the element class is redefined in simdevices.click
 */
elementclass ToDumpEther {
  $file_name |
//  dump_ether  :: ToDump($file_name.pcap, SNAPLEN 0, ENCAP ETHER);
||
  DUMP $dump_element |
//  input -> ToDumpDlg($dump_element/dump_ether) -> output;
    input -> output;
}
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */


/**
 * Element class for a dhcp client. Uses the DHCPClient from the dhcp package.
 * 
 * input: ip-encaped dhcp packets
 * ouput dhcp packets encaped in ip/udp
 *
 * $addr - own hardware address.
 * $req_addr - the address to request.
 * $start_s - start time in sec.
 */
elementclass DHCPClient{ 
  $addr, REQ_ADDR $req_addr, START $start_s |
  
	client :: DHCPClient($addr, REQ_ADDR $req_addr, START $start_s);
	
	input
		-> CheckIPHeader(0)
		-> CheckUDPHeader()
		-> CheckDHCPMsg()
		-> [0]client;
		
	client[0]
		-> UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67)
		-> [0]output;		
	
	queue::DHCPOfferMsgQueue(client.client_ip_read) 
		-> [1]client; //pull 
	
	client[1] 
		-> udp_encap :: UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67)
		-> DHCPUnicastEncap(client.client_ip_read, client.server_ip_read)
		-> [1]output
	
	client[2] -> queue;
	client[3] -> Discard;
}

/**
 * NS2 needs ethernet headers, JiST not. If using ns2, uncomment the AddEtherNsclick.
 */
elementclass AddSimHeader {
  //input -> AddEtherNsclick() -> output;
  input -> output;
}

/**
 * NS2 needs ethernet headers, JiST not. If using ns2, uncomment the Strip.
 */
elementclass StripSimHeader {
  //input -> Strip(14) -> output;
  input -> output;
}

/**
 * Element class FromDevice for simulation purposes with JiST/SWANS. If it is
 * a wifi device, it will also put out transmission feedback.
 * 
 * output[0] Frames from the specified device. 
 */
elementclass FromDevice { 
  $dev_name |

  // only wifi frames are feedbacked
  FromSimDevice($dev_name, 4096, TXFEEDBACK true) 
		-> StripSimHeader()
	  -> SetTimestamp()
		-> [0]output;
}

/**
 * Element class ToDevice for simulation purposes with JiST/SWANS. 
 * 
 * Note: The encap is set to unknown, i.e. we conduct no runtime type checks
 * for packets given to that device. It is assumed that we get the right type.
 *
 * input[0] Input for frames from click to the simulator using the specified device.
 */
elementclass ToDevice { $dev_name |

	input[0]
  	-> AddSimHeader()
  	-> ToSimDevice($dev_name, ENCAP UNKNOWN);
}

/**
 * Element class FromHost for simulation purposes with JiST/SWANS. It issues 
 * ARP requests on its output which must be answered on through its input.
 *
 * If the second form without static ip is used, a DHCP client queries for an
 * ip address after 20s simulation time.
 * 
 * Limitation: JiST/SWANS currently supports only one FromHost element per
 * click instance (see ClickRouter in JiST).
 * 
 * TODO make IPFilter working
 * 
 * input[0]  ARP replies for the issued requests.
 * output[0] Frames from the specified device. 
 */
elementclass FromHost {
	  $dev_name, $ip, ETHER $addr |
  
  from_sim_device :: FromSimDevice($dev_name, 4096, TXFEEDBACK false, TUNNEL true);
  
  from_sim_device[0]
  	-> StripSimHeader()
  	-> CheckIPHeader(0)
  	-> ip_filter :: IPClassifier(src host $ip, -)
		-> arp :: ARPQuerier($ip, $addr)
	  -> SetTimestamp()
		-> [0]output;

	ip_filter[1]
	  //-> IPPrint("packet with wrong src ip from host")
	  -> Discard;

  from_sim_device[1]
    -> [1]arp;
||
  $dev_name, ETHER $addr |

  from_sim_device :: FromSimDevice($dev_name, 4096, TXFEEDBACK false, TUNNEL true);

  AddressInfo(req_addr $dev_name:eth)
  dhcp_client :: DHCPClient($addr, REQ_ADDR req_addr:ip, START 30);

  from_sim_device[0]
  	-> StripSimHeader()
  	-> CheckIPHeader(0)
  	-> ip_filter :: IPClassifier(src host req_addr:ip, -)
		-> arp :: ARPQuerier(req_addr:ip, $addr)
	  -> SetTimestamp()
		-> [0]output;

	ip_filter[1]
	  //-> IPPrint("packet with wrong src ip from host")
	  -> Discard;

  dhcp_output :: Null
//    -> UDPIPEncap(0.0.0.0, 68, 255.255.255.255, 67)
    -> EtherEncap(0x0800, $addr, FF:FF:FF:FF:FF:FF)
	  -> SetTimestamp()
    -> [0]output;

  dhcp_client[0]
    -> dhcp_output;

  dhcp_client[1]
    -> dhcp_output;

  //--------------------------------------------------------------------
  // handle tunneled packets
  from_sim_device[1]
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -);

  ethertype_clf[0]
    -> [1]arp;

  ethertype_clf[1]
    -> EtherDecap()	
	  -> CheckIPHeader(0)
//	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
//    -> Strip(28) // strip ip and udp
	  -> dhcp_client;
	
	bogus :: Null
	  -> Print("ERROR: got unexpected packet (waiting for ARP and DHCP)")
	  -> Discard;

	ethertype_clf[2]
	  -> bogus;
	  
//	ip_classifier[1]
//	  -> bogus;
	  
}

/**
 * Element class ToHost for simulation purposes with JiST/SWANS. 
 *
 * input[0] Input for frames from click to the simulator using the local device.
 */
elementclass ToHost { $dev_name |

  to_sim_device :: ToSimDevice($dev_name, ENCAP ETHER, TUNNEL true);

  // arp and dhcp is tunneled to the corresponding FromSimDevice
	input[0]
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -)
  	-> AddSimHeader()
    -> [1]to_sim_device;
  
  ethertype_clf[1]
	  -> CheckIPHeader(14)
	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
    -> [1]to_sim_device;

  // all except arp and dhcp goes to the simulator
  ethertype_clf[2]
  	-> AddSimHeader()
    -> [0]to_sim_device;

  ip_classifier[1]
  	-> AddSimHeader()
    -> [0]to_sim_device;
}

/**
 * Redefinition of the NotifierQueue, sets the sleepiness trigger to 0 (speeds
 * up simulation since unnecessary pulls are prevented).
 */
elementclass NotifierQueue {
    __REST__ $rest |

  input[0]
    -> NotifierQueue($rest, SLEEPINESS_TRIGGER 0)
    -> [0]output;
}

/**
 * Redefinition of the Queue, sets the sleepiness trigger to 0 (speeds
 * up simulation since unnecessary pulls are prevented).
 */
elementclass Queue {
    __REST__ $rest |

  input[0]
    -> Queue($rest, SLEEPINESS_TRIGGER 0)
    -> [0]output;
}

/**
 * Redefinition of the element ControlSocket.
 * Since we are simulating, we do not need a ControlSocket. Use the 
 * ClickSimController Tool instead.
 */
elementclass ControlSocket {
    __REST__ $rest |
}

/**
 * Redefinitions of the elements AthdescDecap and AthdescEncap.
 * Since we use extra header in simulation, redifine the decap.
 */
elementclass AthdescDecap {
  input -> ExtraDecap() -> output;
}
elementclass AthdescEncap {
  input -> ExtraEncap() -> output;
}
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/**
 * Element class for wifi devices.
 *
 * input[0]  send to device
 * output[0] captured frames without feedback
 * output[1] frames with tx feedback
 */
elementclass WifiDevice {
  $dev_name |

  dump_wifi :: ToDumpWifi($dev_name);

  FromDevice($dev_name) 
    -> AthdescDecap() // You must have set "echo '804' > /proc/sys/net/ath0/dev_type" with madwifi-ng driver
    -> ToDumpWifi(DUMP dump_wifi)
    -> filter_phy :: FilterPhyErr()
    -> filter :: FilterTX()
    -> WifiDupeFilter()
    -> [0]output;
  
  filter_phy[1]
    -> Discard;

  filter[1]
    -> [1]output;

  input[0]
    -> ToDumpWifi(DUMP dump_wifi)
    -> AthdescEncap() // You must have set "echo '804' > /proc/sys/net/ath0/dev_type" with madwifi-ng driver
    -> ToDevice($dev_name);
}


/**
 * Element class for ethernet devices.
 * 
 * input[0]  send to device
 * output[0] captured frames from the device
 */
elementclass EthDevice {
  $dev_name |
  
  dump_ether :: ToDumpEther($dev_name);

  //FromDevice($dev_name)
  Idle()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;

  input[0]
    -> ToDumpEther(DUMP dump_ether)
    //-> ToDevice($dev_name);
    -> Discard();
}

/**
 * Element class for virtual devices,
 * The first form is meant to be used with an external dhcp client,
 * the second form uses a static given ip address for the local device and
 * the third form uses an internal dhcp client to configure the device.
 * 
 * input[0]  send to device
 * output[0] captured frames from the device
 *
 * @param $dev_name the name of the device, e.g. eth0
 * @param $addr the mac address to use with the device
 * @param $ip the ip address to use with the local device
 * @param $dhcp_start the time in ms to start internal dhcp client.
 */
elementclass VirtualDevice { 
  $dev_name, ETHER $addr |
  
  dump_ether :: ToDumpEther($dev_name);

  from_host :: FromHost($dev_name, ETHER $addr)
    -> SetEtherAnno()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
  
  input[0]
    -> ToDumpEther(DUMP dump_ether)
    -> SetPacketType(HOST)
    -> to_host :: ToHost($dev_name);
|| 
  $dev_name, $ip, ETHER $addr |

  dump_ether :: ToDumpEther($dev_name);

	from_host :: FromHost($dev_name, $ip, ETHER $addr)
    -> SetEtherAnno()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
  
  input[0]
    -> ToDumpEther(DUMP dump_ether)
		-> SetPacketType(HOST)
    -> to_host :: ToHost($dev_name)
/*
|| 
  $dev_name, ETHER $addr, START $dhcp_start_s |

  dump_ether :: ToDumpEther($dev_name);

  AddressInfo(req_addr $dev_name:eth)
  dhcp_client :: DHCPClient($addr, req_addr:ip, $dhcp_start_s);

	from_host :: FromHost($dev_name, ADDR $addr, IP req_addr:ip)
    -> SetEtherAnno()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
  
  input[0]
    -> ToDumpEther(DUMP dump_ether)
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -)
		-> from_host;

	to_host :: Null
		-> SetPacketType(HOST)
    -> ToHost($dev_name)

	ethertype_clf[1]
	  -> CheckIPHeader(14)
	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
    -> EtherDecap()	
    -> Strip(28) // strip ip and udp
	  -> dhcp_client;

	ethertype_clf[2]
		-> to_host;
	
	ip_classifier[1]
		-> to_host;
	
  dhcp_output :: Null
    -> UDPIPEncap(0.0.0.0, 68, 255.255.255.255, 67 )
    -> EtherEncap(0x0800, $addr, FF:FF:FF:FF:FF:FF)
	  -> SetTimestamp()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;

  dhcp_client[0]
    -> dhcp_output;

  dhcp_client[1]
    -> dhcp_output;
*/
}


//include(enable-dump.click);

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */


/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * OLSR integration
 * -inputs packets for the kernel (to reach olsr userspace daemon)
 * -outputs packets from the olsr daemon
 */

/* Parameter:
 * ==========
 * - INTERFACE       := interface used for the communication with olsr daemon
 * - MAC             := MAC address for INTERFACE
 * - IP/NETMASK      := IP address and netmask for INTERFACE
 * - SSID            := SSID to associate with
 * - CHANNEL         := channel to use
 *
 */

/* In- and Output ports:
 * =====================
 *  - input[0]        <- 802.11 frames
 *  - [0]output       -> 802.11 frames encaped for olsr to wifi device
 */

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

elementclass AdHocOrInfraStructureClient {
    ETH $eth, SSID $ssid, CHANNEL $channel , WIFIENCAP $clientwifiencap, 
    WIRELESS_INFO $auth_info |

    auth_rates :: AvailableRates(DEFAULT 2 4 11 12 18 22);

    probe_req :: ProbeRequester(WIRELESS_INFO $auth_info, ETH $eth, RT auth_rates);
    auth_req :: OpenAuthRequester(ETH $eth, WIRELESS_INFO $auth_info);
    assoc_req :: BRNAssocRequester(ETH $eth, WIRELESS_INFO $auth_info, RT auth_rates);

    bs :: BeaconScanner(RT auth_rates);
    // TODO set to 5, 5 in real deployment
    st_hnd :: StationHandover(assoc_req, $auth_info, 2, 5)

    isc :: InfrastructureClient(WIRELESS_INFO $auth_info, RT auth_rates, 
      BEACONSCANNER bs, PROBE_REQUESTER probe_req, AUTH_REQUESTER auth_req, 
      ASSOC_REQUESTER assoc_req, WIFIENCAP $clientwifiencap );

	  //all :: CompoundHandler("debug", "BRNAssocRequester InfrastructureClient", "2");
	  

    input[0]
    -> mgt_cl :: Classifier(0/00%f0, //Association Request
                            0/10%f0, //Association Response
                            0/20%f0, //Reassociation Request            
                            0/30%f0, //Reassociation Response
		        0/40%f0, //Probe Request 
                            0/50%f0, //Probe Response
                            0/80%f0, //Beacon
			    0/90%f0, //ATIM (Power Save)
                            0/a0%f0, //Deassociation
                            0/b0%f0, //Authentification
			    0/c0%f0  //De-Authentification
          );


    mgt_cl[0]  //Association Request
    -> Discard;    

    mgt_cl[1]  //Association Response
//  -> Print("Bekomme Association Response")
    -> assoc_req
//  -> Print("Sende Association Request")
    -> [0]output;

    mgt_cl[2]  //Reassociation Request
    -> Discard;

    mgt_cl[3]  //Reassociation Response
//  -> Print("Bekomme Reassociation Response")
    -> assoc_req;

    mgt_cl[4]  //Probe Request
    -> Discard;

    mgt_cl[5]  //Probe Response
  //-> PrintWifi("Bekomme Probe Response in den Beaconscanner")
    -> bs
    -> Discard;
    
    probe_req
//  -> Print("Send Probe",64)
    -> [0]output;

    mgt_cl[6]  //Beacon
  //-> PrintWifi("Bekomme Beacon: ")
    -> st_hnd
    -> bs;

    mgt_cl[7]  //ATIM (Power Save)
    -> Discard;

    mgt_cl[8]  //Deassociation
//  -> Print("Bekomme deassoc",64)
    -> assoc_req;

    mgt_cl[9]  //Authentification
//    -> Print("bekomme AUTH")
    -> auth_req    
//    -> Print("Send AUTH ",128)
    -> [0]output;

    mgt_cl[10]  //De-Authentification
    -> Discard;

}

elementclass _OLSR_Impl {
    MAC $mac, SSID $ssid, CHANNEL $channel, WIRELESS_INFO $auth_info |

  olsr_wifiencap ::  WifiEncap(0x00, WIRELESS_INFO $auth_info);

  olsr_client :: AdHocOrInfraStructureClient(
                                               ETH $mac,
                                               SSID $ssid,
                                               CHANNEL $channel,
                                               WIFIENCAP olsr_wifiencap,
                                               WIRELESS_INFO $auth_info
                                              );

  input[0]
  -> wifi_type_clf :: Classifier(0/00%0f, // management frames
                                 0/08%ff, // pure data frames (subtype == 0x0)
                                 -)       // discard all other
  -> olsr_client
  -> [0]output;

	input[1]
  -> olsr_wifiencap
  -> [0]output;

	wifi_type_clf[1]
  -> HostWifiFilter($mac, $auth_info, MODE 0)
  -> WifiDecap()
  -> suppress_brn_clf :: Classifier(12/8086, -)
  
  // Discard all brn going to the virtual device
  suppress_brn_clf[1]
  -> [1]output;

  suppress_brn_clf[0]
	-> Discard;

	wifi_type_clf[2]
	-> Print("Received strange frame")
	-> Discard;
}


elementclass OLSR {
    INTERFACE $device, MAC $mac, IPNETMASK $ip_netmask, SSID $ssid, CHANNEL $channel 
|
  auth_info :: WirelessInfo(SSID $ssid, BSSID 00:00:00:00:00:00 , CHANNEL $channel);
	olsr_device :: VirtualDevice($device, $ip_netmask, ETHER $mac)
	impl :: _OLSR_Impl(MAC $mac, SSID $ssid, CHANNEL $channel, WIRELESS_INFO auth_info);
	
	input[0]
	  -> [0]impl;
	
	impl[0]
	  -> [0]output;

	olsr_device[0]
	  -> [1]impl;
	
	impl[1]
	  -> [0]olsr_device;
||
    INTERFACE $device, MAC $mac, SSID $ssid, CHANNEL $channel 
|
  auth_info :: WirelessInfo(SSID $ssid, BSSID 00:00:00:00:00:00 , CHANNEL $channel);
	olsr_device :: VirtualDevice($device, ETHER $mac)
	impl :: _OLSR_Impl(MAC $mac, SSID $ssid, CHANNEL $channel, WIRELESS_INFO auth_info);
	
	input
	  -> [0]impl;
	
	impl[0]
	  -> output;

	olsr_device
	  -> [1]impl;
	
	impl[1]
	  -> olsr_device;
}

///////////////////////////////////////////////////////////////////

/* Usage:
 * ======
 * AddressInfo(olsr_dev $wifi_dev:eth);
 * AddressInfo(olsr_ip 104.142.0.67/8);
 *
 * olsr :: OLSR(INTERFACE olsr, MAC $olsr_dev, IP/NETMASK $olsr_ip,
 *              SSID "olsr.freifunk.net", CHANNEL 10);
 *
 */

/* Examples:
 * =========
 *
 * AddressInfo(olsr_dev $wifi_dev:eth);
 * AddressInfo(olsr_ip 104.142.0.67/8);
 *
 * olsr :: OLSR(INTERFACE olsr, MAC olsr_dev, IP/NETMASK olsr_ip,
 *              SSID "olsr.freifunk.net", CHANNEL 10);
 *
 * FromDevice(ath0)
 * -> Prism2Decap()
 * -> ExtraDecap()
 * //-> HostWifiFilter(DROP_OTHER TRUE, ETHER my_wifi_dev)
 * -> [0]olsr[0]
 * -> out :: Queue()
 * -> Prism2Encap()
 * -> ToDevice(ath0);
 *
 */

elementclass Station {
  SSID $ssid, WIFI_DEV $wifi_dev, WIFI_CHANNEL $channel, LOCAL_DEV $local_dev |
  
  wifi_device :: WifiDevice($wifi_dev);
  
	olsr :: OLSR(INTERFACE $local_dev, MAC $wifi_dev:eth, SSID $ssid, CHANNEL $channel);
	
	wifi_device
    -> olsr_filter :: HostWifiFilter($wifi_dev:eth, olsr/auth_info, MODE 1)
	  -> olsr;

  // inject management frames without considering bssid
  olsr_filter[1]
    -> mgnt_clf :: Classifier(0/00%0f ,-)
    -> HostWifiFilter($wifi_dev:eth, olsr/auth_info, MODE 3)
    -> olsr;

	mgnt_clf[1]
	  -> Discard;
	  
  wifi_device[1]
    -> Discard;


	// Filter and buffer packets if not associated
	assoc_filter :: ReadHandlerFilter(olsr/impl/olsr_client/assoc_req.associated, "1");
	assoc_q :: NotifierQueue(20);
	
	olsr
	  -> queue :: NotifierQueue(50)
	  -> assoc_filter
	  -> wifi_device;

	assoc_filter[1]
	  -> Print("Client buffering packet")
		-> assoc_q
  	-> WifiDecap()
  	-> WifiEncap(0x01, WIRELESS_INFO olsr/auth_info)
	  -> Print("Client unbuffering packet")
	  -> [1]assoc_filter;
}



station :: Station(SSID "BerlinRoofNet", WIFI_DEV ath0, WIFI_CHANNEL 10, LOCAL_DEV local);

//todump_active :: CompoundHandler("active", "ToDump");

ControlSocket("TCP", 7777);

Script(
  write station/olsr/impl/olsr_client/isc.debug 2,
  write station/olsr/impl/olsr_client/assoc_req.debug 3,
  write station/olsr/impl/olsr_client/st_hnd.debug 3,
  
  write station/assoc_filter.debug 2,
  
  wait 10,
  read station/olsr/impl/olsr_client/isc.wireless_info,
  wait 30,
  read station/olsr/olsr_device/from_host/dhcp_client/client.lease_read,

//  write station/olsr/olsr_device/from_host/dhcp_client.active false,
//  write station/olsr/olsr_device/from_host/dhcp_client.start_time 40000,
//  write station/olsr/olsr_device/from_host/dhcp_client.active true
);
