package brn.swans.app.rtcp;

import jist.runtime.JistAPI;
import jist.swans.misc.Pickle;

public class SDESItem implements JistAPI.Timeless {

  // ////////////////////////////////////////////////
  // constants
  //

  public static int SDES_UNDEF = 0;

  public static int SDES_CNAME = 1;

  public static int SDES_NAME = 2;

  public static int SDES_EMAIL = 3;

  public static int SDES_PHONE = 4;

  public static int SDES_LOC = 5;

  public static int SDES_TOOL = 6;

  public static int SDES_NOTE = 7;

  public static int SDES_PRIV = 8;

  // ////////////////////////////////////////////////
  // locals
  //
  /**
   * The type of this SDESItem.
   */
  protected int type;

  /**
   * The length of this SDESItem.
   */
  protected int length;

  /**
   * The sdes string.
   */
  protected String content;

  // ////////////////////////////////////////////////
  // initialization
  //

  /**
   * Constructor which sets the entry.
   */
  public SDESItem() {
    this.type = SDES_UNDEF;
    this.content = "";
    this.length = 2;
  }

  public SDESItem(int type, String content) {
    this.type = type;
    this.content = content;
    // an sdes item requires one byte for the type field,
    // one byte for the length field and bytes for
    // the content string
    this.length = 2 + content.length();
  }

  public SDESItem(byte[] msg, int offset) {
    // Byte 0: type
    type = (byte) Pickle.arrayToUByte(msg, offset);
    // Byte 1: length
    int len = Pickle.arrayToUByte(msg, offset + 1);
    // Byte 2-x: content
    content = new String(msg, offset+2, len);

    this.length = 2 + content.length();
  }

  // ////////////////////////////////////////////////
  // accessors
  //

  public String getContent() {
    return content;
  }

  public int getLength() {
    return length;
  }

  public int getType() {
    return type;
  }

  // ////////////////////////////////////////////////
  // overwrites
  //

  public String toString() {
    return ("SDESItem [type=" + type + ", content=" + content + "]");
  }

  public int getBytes(byte[] msg, int offset) {

    // Byte 0: type
    Pickle.ubyteToArray(type, msg, offset);
    // Byte 1: length
    Pickle.ubyteToArray(content.length(), msg, offset + 1);
    // Byte 2-x: content
    byte[] cont = content.getBytes();
    System.arraycopy(cont, 0, msg, offset+2, cont.length);

    return offset + 2 + cont.length;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  public int hashCode() {
    final int PRIME = 31;
    int result = 1;
    result = PRIME * result + ((content == null) ? 0 : content.hashCode());
    result = PRIME * result + length;
    result = PRIME * result + type;
    return result;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    final SDESItem other = (SDESItem) obj;
    if (content == null) {
      if (other.content != null)
        return false;
    } else if (!content.equals(other.content))
      return false;
    if (length != other.length)
      return false;
    if (type != other.type)
      return false;
    return true;
  }

}
