package brn.swans.app.rtcp.msg;

import java.util.ArrayList;
import java.util.List;

import jist.runtime.Main;
import jist.swans.misc.Util;
import brn.swans.app.rtcp.SDESChunk;

/**
 * An object of this class holds 0 to 31 source description chunks for
 * participants of the rtp session.
 */
public class RtcpSDESMessage extends RtcpMessage {

  // ////////////////////////////////////////////////
  // constants
  //

  // ////////////////////////////////////////////////
  // locals
  //

  /**
   * In this cArray the sdes chunks are stored.
   */
  protected List sdesChunks;

  // ////////////////////////////////////////////////
  // initialization
  //

  public RtcpSDESMessage() {
    packetType = RTCP_PT_SDES;
    sdesChunks = new ArrayList();
    // no addLength() needed, sdes chunks
    // directly follow the standard rtcp
    // header
  }

  // ////////////////////////////////////////////////
  // accessors
  //

  public RtcpSDESMessage(byte[] msg, int offset) {
    super(msg, offset);
    sdesChunks = new ArrayList();

    if (Main.ASSERT)
      Util.assertion(RTCP_PT_SDES == packetType);

    // Bytes 4-: sdes chunks
    offset += COMMON_HEADER_SIZE;
    for (int i = 0; i < count; i++) {
      SDESChunk sdes = new SDESChunk(msg, offset);
      offset += sdes.getLength();
      sdesChunks.add(sdes);
    }
  }

  public List getSdesChunks() {
    return sdesChunks;
  }

  public void addSdesChunk(SDESChunk sdesChunk) {
    sdesChunks.add(sdesChunk);
    count++;
    // the size of the rtcp packet increases by the
    // size of the sdes chunk (including ssrc)
    length += sdesChunk.getLength();
  }

  // ////////////////////////////////////////////////
  // overwrites
  //

  public String toString() {
    String ret = "RTCPSDESPacket [";
    for (int i = 0; i < sdesChunks.size(); i++) {
      ret += sdesChunks.get(i).toString();
    }
    return ret + "]";
  }

  /*
   * (non-Javadoc)
   * @see brn.swans.app.rtcp.msg.RtcpMessage#getBytes(byte[], int)
   */
  public void getBytes(byte[] msg, int offset) {
    // Bytes 0-3: get the common header
    offset = super.getCommonHeaderBytes(msg, offset);
    // Bytes 4-: sdes chunks
    for (int i = 0; i < sdesChunks.size(); i++) {
      SDESChunk sdes = (SDESChunk) sdesChunks.get(i);
      offset = sdes.getBytes(msg, offset);
    }
  }

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  public int hashCode() {
    final int PRIME = 31;
    int result = super.hashCode();
    result = PRIME * result + ((sdesChunks == null) ? 0 : sdesChunks.hashCode());
    return result;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (!super.equals(obj))
      return false;
    if (getClass() != obj.getClass())
      return false;
    final RtcpSDESMessage other = (RtcpSDESMessage) obj;
    if (sdesChunks == null) {
      if (other.sdesChunks != null)
        return false;
    } else if (!sdesChunks.equals(other.sdesChunks))
      return false;
    return true;
  }


}
