package brn.swans.app.rtp.profile;

import java.io.IOException;
import java.util.Arrays;

/**
 * Payload receiver for type 10, L16 Audio at 44100 samples and 2 channels
 * 
 * @author kurth
 */
public class RtpAvProfilePayload0Receiver extends
    RtpAvProfileSampleBasedAudioReceiver {

  // ////////////////////////////////////////////////
  // constants
  //

  // ////////////////////////////////////////////////
  // locals
  //

  // ////////////////////////////////////////////////
  // initialization
  //

  public RtpAvProfilePayload0Receiver() {
    sampleWidth = 16;
    samplingRate = 44100;
    numberOfChannels = 2;
  }

  // ////////////////////////////////////////////////
  // accessors
  //

  // ////////////////////////////////////////////////
  // overwrites
  //

  protected void insertSilence(long duration) {
    
    // one sample is 32 bit (2 channels, both 16 bit)
    int numberOfSamples = (int)(duration / ((float)samplingRate));
    byte[] data = new byte[4*numberOfSamples];
    Arrays.fill(data, (byte)0);
    
      try {
        output.write(data);
      } catch (IOException e) {
        // TODO Auto-generated catch block
        throw new RuntimeException(e);
      }
  }
  
}
