package brn.swans.app.rtp.profile;

import jist.swans.Constants;

/**
 * Payload sender for type 10, L16 Audio at 44100 samples and 2 channels
 * 
 * @author kurth
 */
public class RtpAvProfilePayload10Sender extends
    RtpAvProfileSampleBasedAudioSender {


  // ////////////////////////////////////////////////
  // constants
  //

  // ////////////////////////////////////////////////
  // locals
  //

  // ////////////////////////////////////////////////
  // initialization
  //

  public RtpAvProfilePayload10Sender() {
    payloadType = 10;
    clockRate = 44100;
    samplingRate = 44100;
    sampleWidth = 16;
    numberOfChannels = 2;
    
    bytesPerSample = sampleWidth / 8;
    packetizationInterval = 20 * Constants.MILLI_SECOND;
  }

  // ////////////////////////////////////////////////
  // accessors
  //

  // ////////////////////////////////////////////////
  // overwrites
  //

}
