package brn.swans.app.rtp.profile;

import java.io.IOException;

import jist.swans.misc.MessageBytes;
import brn.swans.app.rtp.RtpPayloadReceiver;
import brn.swans.app.rtp.msg.RtpMessage;

/**
 * Receiver corresponding to {@link RtpAvProfileSampleBasedAudioSender}
 * 
 */
public abstract class RtpAvProfileSampleBasedAudioReceiver extends RtpPayloadReceiver {

  // ////////////////////////////////////////////////
  // constants
  //

  // ////////////////////////////////////////////////
  // locals
  //

  /**
   * sampling rate for output.
   */
  int samplingRate;

  /**
   */
  int sampleWidth;

  /**
   */
  int numberOfChannels;

  // ////////////////////////////////////////////////
  // initialization
  //

  public RtpAvProfileSampleBasedAudioReceiver() {

  }

  // ////////////////////////////////////////////////
  // accessors
  //

  // ////////////////////////////////////////////////
  // overwrites
  //

  // ////////////////////////////////////////////////
  // Called by rtp profile
  //

  // ////////////////////////////////////////////////
  // Implementation
  //

  protected void processPacket(RtpMessage packet) {
    super.processPacket(packet);
    
    MessageBytes payload = (MessageBytes) packet.getPayload();
    try {
      output.write(payload.getBytes());
    } catch (IOException e) {
      // TODO Auto-generated catch block
      throw new RuntimeException(e);
    }
  }

  /**
   * When packets arrival late or have been lost, this method can be called to
   * insert a silence period. It must be overwritten because in different audio
   * formats different values for silence exist.
   */
  protected void insertSilence(long duration) {
    // depends at least on sampling rate and sample width
  }

}
