package test;

import java.util.ArrayList;
import java.util.List;

import brn.sim.AbstractParams;
import brn.sim.builder.RtpAppBuilder;
import brn.sim.builder.RtpFlowBuilder;
import click.runtime.ClickAdapter;
import click.sim.builder.ClickBuilder;
import click.sim.builder.ClickBuilder.NetParams;

public abstract class TestDriver extends brn.sim.AbstractDriver {

  /*
   * (non-Javadoc)
   * @see brn.sim.AbstractDriver#installHandlers(brn.sim.AbstractParams)
   */
  protected void installHandlers(AbstractParams options) throws Exception {
    super.installHandlers(options);

    List netParams = new ArrayList();
    if (options.node != null)
      netParams.add(options.node.net);
    for (int i = 0; i < options.nodeParams.length; i++)
      if (options.nodeParams[i] != null)
        netParams.add(options.nodeParams[i].net);

    // Use gui
    for (int i = 0; i < netParams.size(); i++) {
      if (netParams.get(i) instanceof ClickBuilder.NetParams) {
        NetParams params = (NetParams) netParams.get(i);
        if (params.clickGui)
          ClickAdapter.useGui();
      }
    }
  }

  protected void installBuilders(AbstractParams options) {
    super.installBuilders(options);

    builderProvider.addBuilder(new ClickBuilder.Net());
    builderProvider.addBuilder(new ClickBuilder.Mac());
    builderProvider.addBuilder(new RtpAppBuilder());
    builderProvider.addBuilder(new RtpFlowBuilder());
  }

}