package test.brn.scenario.handoff;

import click.sim.builder.ClickBuilder;

import jist.swans.Constants;
import jist.swans.misc.Util;
import brn.sim.AbstractParams;
import brn.sim.builder.FlowBuilder;
import brn.sim.builder.Builder;
import brn.sim.builder.NodeBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.RtpAppBuilder;
import brn.sim.builder.TransBuilder;
import brn.sim.builder.FlowBuilder.TcpParams;
import brn.sim.builder.Builder.Params;
import brn.sim.builder.NodeBuilder.NodeParams;
import brn.sim.builder.RtpAppBuilder.RtpAppParams;

public class HandoffParams extends AbstractParams {
  private static final long serialVersionUID = 1L;

  /** Number of client-server pairs. */
  public int clients = 10;
  /** Client parameters. */
  public NodeBuilder.NodeParams client;

  public RtpAppBuilder.RtpAppParams rtpParams = null;

  public FlowBuilder.TcpParams tcpParams = null;

  public TransBuilder.Params transParams = null;

  /** Whether to use the brn handoff optimizations */
  public boolean optimize = false;
  /** for how long the mesh node delays the reassoc response */
  public int reassocDelay_ms = 0;


  public static void main(String[] args) throws Exception {
    HandoffParams params = new HandoffParams();

    params.rtpParams = new RtpAppBuilder.RtpAppParams();
    params.transParams = new TransBuilder.UdpParams();

    params.client = (NodeParams) params.node.clone();
    if (params.client.net instanceof ClickBuilder.NetParams) {
      ClickBuilder.NetParams click = (ClickBuilder.NetParams) params.client.net;
      click.clickfile = "res/click/station.click";
      click.netPromisc = false;
    }

    ClickBuilder.MacParams mac = (ClickBuilder.MacParams) params.client.mac;
    mac.macPromisc = false;
    mac.isStation = true;

    RadioBuilder.NoiseParams radio = (RadioBuilder.NoiseParams) params.client.radio;
    radio.placement = Constants.PLACEMENT_RANDOM;
    //place = new Placement.Manual(new Location.Location2D(opts.fieldX-500, opts.fieldY-500));

    // and out
    Util.writeObject("res/config/HandoffParams.xml", params);
  }


  public NodeBuilder.NodeParams getClient() {
    return client;
  }


  public void setClient(NodeBuilder.NodeParams client) {
    this.client = client;
  }


  public int getClients() {
    return clients;
  }


  public void setClients(int clients) {
    this.clients = clients;
  }


  public boolean isOptimize() {
    return optimize;
  }


  public void setOptimize(boolean optimize) {
    this.optimize = optimize;
  }


  public int getReassocDelay_ms() {
    return reassocDelay_ms;
  }


  public void setReassocDelay_ms(int reassocDelay_ms) {
    this.reassocDelay_ms = reassocDelay_ms;
  }


  public RtpAppBuilder.RtpAppParams getRtpParams() {
    return rtpParams;
  }


  public void setRtpParams(RtpAppBuilder.RtpAppParams rtpParams) {
    this.rtpParams = rtpParams;
  }


//  public int getStationMobilityStart() {
//    return stationMobilityStart;
//  }
//
//
//  public void setStationMobilityStart(int stationMobilityStart) {
//    this.stationMobilityStart = stationMobilityStart;
//  }
//

  public FlowBuilder.TcpParams getTcpParams() {
    return tcpParams;
  }


  public void setTcpParams(FlowBuilder.TcpParams tcpParams) {
    this.tcpParams = tcpParams;
  }


  public Builder.Params getTransParams() {
    return transParams;
  }


  public void setTransParams(Builder.Params transParams) {
    this.transParams = transParams;
  }


  /* (non-Javadoc)
   * @see brn.sim.AbstractParams#clone()
   */
  public Object clone() throws CloneNotSupportedException {
    HandoffParams ret = (HandoffParams) super.clone();
    if (null != client) ret.client = (NodeParams) client.clone();
    if (null != rtpParams) ret.rtpParams = (RtpAppParams) rtpParams.clone();
    if (null != tcpParams) ret.tcpParams = (TcpParams) tcpParams.clone();
    if (null != transParams) ret.transParams = (Params) transParams.clone();
    return ret;
  }
}
