package test.brn.swans.app.rtp;

import jist.swans.Constants;
import brn.sim.AbstractParams;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.NodeBuilder;
import brn.sim.builder.PathLossBuilder;
import brn.sim.builder.RouteBuilder;
import brn.sim.builder.TrafficBuilder;
import brn.sim.builder.TransBuilder;
import brn.sim.builder.NetBuilder.IpParams;
import brn.sim.builder.NodeBuilder.TrafficParams;
import brn.sim.builder.RadioBuilder.NoiseParams;
import brn.sim.builder.RtpFlowBuilder.RtpFlowParams;


public class RtpParams extends AbstractParams {
  private static final long serialVersionUID = 1L;

  public static RtpParams defaultParams() {
    RtpParams opts = new RtpParams();

//    opts.dumpNetNam = "sim-out.nam";
//    opts.dumpNet = true;
    opts.assertion = true;
    opts.seed = 1;

    FieldBuilder.FieldParams field = (FieldBuilder.FieldParams) opts.field;
    field.fieldX = 100;
    field.fieldY = 100;
    field.pathloss = new PathLossBuilder.FreeSpaceParams();

    opts.nodeNumber = new int[] {2};
    opts.nodeParams = new NodeBuilder.NodeParams[1];

    opts.nodeParams[0] = new NodeBuilder.TrafficParams();
    NoiseParams radio = (NoiseParams) opts.nodeParams[0].radio;
    radio.placement = Constants.PLACEMENT_RANDOM;

    IpParams ipParams = (IpParams) opts.nodeParams[0].net;
    ipParams.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_TCP, Constants.NET_PROTOCOL_AODV,
        Constants.NET_PROTOCOL_DSR};

    RouteBuilder.DsrParams route = new RouteBuilder.DsrParams();
    route.protocol = Constants.NET_PROTOCOL_DSR;
    opts.nodeParams[0].route = route;

    ((TrafficParams)opts.nodeParams[0]).trans = new TransBuilder.UdpParams();

    RtpFlowParams rtpParams = new RtpFlowParams();
    rtpParams.start = 60;
    rtpParams.duration = 10;

    TrafficBuilder.RadialGatewayParams traffic = new TrafficBuilder.RadialGatewayParams();
    traffic.flowParams = rtpParams;
    traffic.flows = 1;
    ((TrafficParams)opts.nodeParams[0]).traffic = traffic;

    return opts;
  }

}
