package test.brn.swans.app.rtp;

import test.TestDriver;
import brn.sim.builder.NodeBuilder;
import brn.sim.builder.FieldBuilder.FieldParams;
import brn.sim.builder.RtpFlowBuilder.RtpFlowParams;
import brn.sim.builder.TrafficBuilder.RadialGatewayParams;

/**
 * Scenario with a gateway and randomized placed mesh nodes. the clients
 * communicate with the gateway.
 *
 * @author kurth
 *
 */
public class RtpTest extends TestDriver {

  public static void main(String[] args) throws Throwable {
    RtpTest test = new RtpTest();

    test.run(args);
  }

  protected void runTest(String version) {
    if (!version.equals("1"))
      throw new RuntimeException("unknown version: " + version);

    RtpParams options = RtpParams.defaultParams();
    options.seed = 2;
    options.endTime = 240;

    options.nodeNumber = new int[] {100};
    FieldParams field = (FieldParams) options.field;
    field.fieldX = 4000;
    field.fieldY = 4000;

    NodeBuilder.TrafficParams tparams = (NodeBuilder.TrafficParams) options.nodeParams[0];
    RadialGatewayParams traffic = (RadialGatewayParams) tparams.traffic;
    traffic.flows = 8;

    RtpFlowParams rtpParams = (RtpFlowParams) traffic.flowParams;
    rtpParams.start = 120;
    rtpParams.duration = 60;
//    options.startOffsett = 5;
    rtpParams.payloadType = 0;
    rtpParams.bandwidth = 8000;

    try {
      super.run(options);
    } catch (Exception e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

}
