package test.sim.scenario;

import jist.swans.Constants;
import test.brn.scenario.handoff.HandoffParams;
import test.brn.scenario.handoff.HandoffTest;
import brn.sim.builder.FlowBuilder;
import brn.sim.builder.FieldBuilder;
import brn.sim.builder.RadioBuilder;
import brn.sim.builder.TransBuilder;
import brn.sim.builder.NodeBuilder.NodeParams;
import brn.sim.builder.PathLossBuilder.DistShadowingParams;
import click.sim.builder.ClickBuilder;


public class TestClickHandoff {

  public static void main(String[] args) throws Exception {
    HandoffParams params =
      (HandoffParams) TestParamBuilder.build(HandoffParams.class);
    HandoffTest test = new HandoffTest();

    // set parameters
    params.gui = false;
    params.seed = 2;
    params.nodes = 25;
    params.endTime = 240;

    DistShadowingParams pathloss = new DistShadowingParams();
    pathloss.exponent = 2.0;
    pathloss.stdDeviation = .0;
    pathloss.coherenceTime = 0;

    FieldBuilder.FieldParams field = (FieldBuilder.FieldParams) params.field;
    field.fieldX = 4000;
    field.fieldY = 4000;
    field.pathloss = pathloss;
    field.spatial_mode = Constants.SPATIAL_HIER;
    field.mobility = Constants.MOBILITY_STATIC;
    field.pause_time = 0;
    field.granularity = 10;
    field.min_speed = 25;
    field.max_speed = 25;

    RadioBuilder.NoiseParams radio = new RadioBuilder.NoiseAdditiveParams();
    radio.placement = Constants.PLACEMENT_GRID;
    radio.placementOpts = "10,10";
    radio.fieldX = field.fieldX;
    radio.fieldY = field.fieldY;
    radio.useAnnos = true;
    radio.startMobility = null;
    params.node.radio = radio;

    ClickBuilder.MacParams mac = new ClickBuilder.MacParams();
    mac.macPromisc = true;
    mac.useAnnos = radio.useAnnos;
    mac.useBitRateAnnos = false;
    params.node.mac = mac;

    ClickBuilder.NetParams net = new ClickBuilder.NetParams();
    net.clickfile = "res/click/meshnode.click";
    net.protocolMapper = new int[] { Constants.NET_PROTOCOL_UDP,
        Constants.NET_PROTOCOL_LINK_PROBE,
        Constants.NET_PROTOCOL_TCP,
    };
    params.node.net = net;
    params.node.route = null;

    params.optimize = false;
    params.clients = 1;

    params.rtpParams = null;
    params.transParams = new TransBuilder.TcpParams();
    params.tcpParams = new FlowBuilder.TcpParams();
    params.tcpParams.tcpBytes = 8000000;
    ((TransBuilder.TcpParams)params.transParams).mss = 1460;
    ((TransBuilder.TcpParams)params.transParams).initWindowSize = 29200;
    params.tcpParams.start = 90000;

    // client parameters
    params.client = (NodeParams) params.node.clone();
    if (params.client.net instanceof ClickBuilder.NetParams) {
      ClickBuilder.NetParams click = (ClickBuilder.NetParams) params.client.net;
      click.clickfile = "res/click/clientnode.click";
      click.netPromisc = false;
    }

    mac = (ClickBuilder.MacParams) params.client.mac;
    mac.macPromisc = false;
    mac.isStation = true;

    radio = (RadioBuilder.NoiseParams) params.client.radio;
    radio.placement = Constants.PLACEMENT_RANDOM;
    radio.startMobility = "" + (85 * Constants.SECOND);
    //place = new Placement.Manual(new Location.Location2D(opts.fieldX-500, opts.fieldY-500));

    try {
//      ClickAdapter.useGui();
      test.run(params);
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }

}
