# sim-lq.py
#
# perform only link probing and calculate link qualities
# (see TestLinkQuality)
#
from jarray import array, zeros
from java.lang import Math
from jist.swans import Constants
import brn.swans.Constants
from brn.sim import *
from brn.sim.builder import *
from brn.sim.scenario.coverage import *

true = 1
false = 0

def gridParams():
  params = LinkQualityParams()

  # general setup
  params.assertion = true
  params.endTime = 500
  params.seed = 1
  params.nodes = 50
  params.gui = true

  params.singeSender = true;

  # field
  params.field.fieldX = 400
  params.field.fieldY = 100
  params.field.spatial_mode = Constants.SPATIAL_LINEAR
  #params.field.pathloss = PathLossBuilder.FreeSpaceParams()
  params.field.pathloss = PathLossBuilder.LogDistanceParams()
  params.field.pathloss.exponent = 3.5
  #DistNewShadowingParams pathLoss = new DistNewShadowingParams()
  #pathLoss.pathloss = lossExp
  #pathLoss.stdDeviation = 4.
  #pathLoss.exponential = false // JistAPI.END !!
  #pathLoss.coherenceTime = JistAPI.END//(long)(2.5 * Constants.SECOND)
  #params.field.fading = FadingBuilder.NoneParams()
  params.field.fading = FadingBuilder.PunnooseRicianParams()
  params.field.fading.maxVelocity = 2.
  params.field.fading.K = 6#-100

  # radio
  params.node.radio = RadioBuilder.NoiseAdditiveBerParams()
  #params.node.radio = RadioBuilder.NoiseAdditiveParams()
  params.node.radio.radioType = Constants.MAC_802_11g_PURE
  params.node.radio.fieldX = params.field.fieldX
  params.node.radio.fieldY = params.field.fieldY
  params.node.radio.placement = Constants.PLACEMENT_GRID
  params.node.radio.placementOpts = "" + str(params.nodes) + "x1"
  params.node.radio.useAnnos = true

  # mac
  params.node.mac = MacBuilder.M802_11Params()
  #params.node.mac.macType = Constants.MAC_802_11g_PURE
  params.node.mac.useAnnos = params.node.radio.useAnnos
  params.node.mac.useBitRateAnnos = true
  params.node.mac.rateSelection.dataBitrate = Constants.BANDWIDTH_6Mbps
  params.node.mac.rateSelection.controlBitrate = Constants.BANDWIDTH_6Mbps

  # net
  params.node.net = NetBuilder.IpNotifyParams()
  params.node.net.protocolMapper = array([ \
      Constants.NET_PROTOCOL_LINK_PROBE, \
    ], 'i')

  # route
  params.node.route = None

  # metric
  size = 1500
  params.metric = MetricBuilder.EtxParams()
  params.metric.probes = array( [ \
          Constants.BANDWIDTH_6Mbps, size, \
          Constants.BANDWIDTH_9Mbps, size, \
          Constants.BANDWIDTH_12Mbps, size, \
          Constants.BANDWIDTH_18Mbps, size, \
          Constants.BANDWIDTH_24Mbps, size, \
          Constants.BANDWIDTH_36Mbps, size, \
          Constants.BANDWIDTH_48Mbps, size, \
          Constants.BANDWIDTH_54Mbps, size, \
    ] , 'i')
  params.metric.period = 1000 / 2 / 60
  params.metric.tau = 30000 / 4 / 60
  params.metric.autoStart = false;
  #params.metric.globalLinkTable = true

  return params


def moveLineParams():
  params = gridParams()

  params.nodes = 2;
  params.endTime = 250;

  # field
  params.field.fieldX = 400
  params.field.fieldY = 100
  params.field.mobility = Constants.MOBILITY_BOUNDLESS_SIM_AREA
  params.field.mobilityOpts = "1:1:0:0:.5:0:1:0"

  # radio
  params.node.radio.fieldX = params.field.fieldX
  params.node.radio.fieldY = params.field.fieldY
  params.node.radio.placement = Constants.PLACEMENT_MANUAL
  params.node.radio.placementOpts = "0x50:0x51"
  params.node.radio.startMobility = "-1:0"
  #params.node.radio.recvCorruptPackets = false

  # metric
  params.metric.period = 1000 / 2 / 60
  params.metric.tau = 30000 / 4 / 60

  return params

#---------------
# main
#---------------

# create test
test = LinkQuality()
#arams = gridParams()
params = moveLineParams()

#params.node.radio.recvCorruptPackets = false
#params.node.radio.bitErrorModel = brn.swans.Constants.BITERRORS_UNIFORM
params.field.mobilityOpts = "1:1:0:0:.05:0:1:0"

params.handlerRadio = true
params.handlerMac = true
params.handlerRate = true
params.handlerRoute = true
params.handlerRadioTimeBar = false
params.handlerLinkQuality = true


# run
test.run(params)
