# sim-udp-dsr-ett.py
#
# simulates a udp flow over a string of nodes running dsr with ett metric 
#
from jarray import array, zeros
from java.lang import Math 
from brn.sim import *
from brn.sim.builder import *
from jist.swans import Constants
import brn.swans.Constants

true = 1
false = 0

def setSampleRate(params):
  params.node.route.bitrateFromLinkTable = false
  params.node.mac.rateSelection = RateBuilder.SampleParams()
  #params.node.mac.rateSelection.macType = params.node.mac.macType
  return params


# create test
test = BasicDriver()
params = DeprecatedBasicParams()

# general setup
params.assertion = true
params.endTime = 100
params.seed = 1
params.nodes = 20

params.handlerRadio = true
params.handlerRate = true
params.handlerRoute = true
params.handlerRadioTimeBar = false
params.handlerForwardGraph = true
params.handlerLinkTable = true



# field
params.field.fieldX = 200
params.field.fieldY = 100
params.field.spatial_mode = Constants.SPATIAL_HIER
params.field.pathloss = PathLossBuilder.ShadowingParams()
params.field.pathloss.stdDeviation = 4.
params.field.pathloss.exponential = false # JistAPI.END !!  
params.field.pathloss.coherenceTime = JistAPI.END
params.field.pathloss.pathloss = PathLossBuilder.LogDistanceParams()
params.field.pathloss.pathloss.exponent = 3.5
params.field.fading = FadingBuilder.NoneParams()
#params.field.fading = FadingBuilder.PunnooseRicianParams()
#params.field.fading.maxVelocity = 1.5
#params.field.fading.K = 0

# radio
params.node.radio = RadioBuilder.NoiseAdditiveBerParams()
#params.node.radio = RadioBuilder.NoiseAdditiveParams()
params.node.radio.radioType = Constants.MAC_802_11g_PURE
params.node.radio.fieldX = params.field.fieldX
params.node.radio.fieldY = params.field.fieldY
params.node.radio.placement = Constants.PLACEMENT_GRID
params.node.radio.placementOpts = "" + str(params.nodes) + "x1"
params.node.radio.useAnnos = true

# mac
params.node.mac = MacBuilder.M802_11Params()
#params.node.mac.macType = Constants.MAC_802_11g_PURE
params.node.mac.useAnnos = params.node.radio.useAnnos
params.node.mac.useBitRateAnnos = true
params.node.mac.rateSelection.dataBitrate = Constants.BANDWIDTH_6Mbps
params.node.mac.rateSelection.controlBitrate = Constants.BANDWIDTH_6Mbps

# net
params.node.net = NetBuilder.IpNotifyParams()
params.node.net.protocolMapper = array([ \
    Constants.NET_PROTOCOL_UDP, \
    Constants.NET_PROTOCOL_LINK_PROBE, \
    Constants.NET_PROTOCOL_MCEXOR, \
    Constants.NET_PROTOCOL_FLOODING \
  ], 'i')

# rotue
params.node.route = RouteBuilder.BrnDsrParams()
params.node.route.protocol = Constants.NET_PROTOCOL_MCEXOR
params.node.route.forwarding = brn.swans.Constants.FORWARDING_UNICAST
params.node.route.discovery = brn.swans.Constants.DISCOVERY_PROACTIVE
params.node.route.floodintOffset = 50000
params.node.route.floodingPeriod = 10000
params.node.route.floodingMax = 0
params.node.route.bitrateFromLinkTable = true
params.node.route.minLinkMetric = 50 * Constants.MILLI_SECOND


params.node.route.metric = MetricBuilder.EttParams()
params.node.route.metric.probes = array( [ \
        Constants.BANDWIDTH_6Mbps, 1000, \
        Constants.BANDWIDTH_9Mbps, 1000, \
        Constants.BANDWIDTH_12Mbps, 1000, \
        Constants.BANDWIDTH_18Mbps, 1000, \
        Constants.BANDWIDTH_24Mbps, 1000, \
        Constants.BANDWIDTH_36Mbps, 1000, \
        Constants.BANDWIDTH_48Mbps, 1000, \
        Constants.BANDWIDTH_54Mbps, 1000, \
  ] , 'i')
params.node.route.metric.period = 1000
params.node.route.metric.tau = 30000
params.node.route.metric.globalLinkTable = true

# traffic
params.trafficParams.flowParams = FlowBuilder.CbrUdpParams()
params.trafficParams.flowParams.start = 80000
params.trafficParams.flowParams.end = 90000
params.trafficParams.flowParams.udpTxRate = 10

# TEST sample rate
#params = setSampleRate(params)

# run
test.run(params)

