package brn.analysis.capacity;

import java.io.Serializable;
import java.util.Collection;
import brn.util.NavigableSet;
import brn.util.TreeSet;

public class ConflictGraph implements Serializable {
  private static final long serialVersionUID = 9080163707013149191L;

  private int[][] adjacencyMatrix;

  public ConflictGraph(int[][] adjacencyMatrix) {
    this.adjacencyMatrix = adjacencyMatrix;
  }

  public boolean isConnected(int node1, int node2) {
    return adjacencyMatrix[node1][node2] > .0;
  }

  public NavigableSet<Integer> getDepartures(int src) {
    NavigableSet<Integer> stNeighbors = new TreeSet<Integer>();
    for (int i = 0; i < adjacencyMatrix.length; i++) {
      if (adjacencyMatrix[src][i] > .0)
        stNeighbors.add(i);
    }
    return stNeighbors;
  }

  public NavigableSet<Integer> getDepartures(Collection<Integer> lstJ) {
    NavigableSet<Integer> stNeighbors = new TreeSet<Integer>();
    for (Integer node : lstJ) {
      stNeighbors.addAll(getDepartures(node));
    }
    return stNeighbors;
  }

  public NavigableSet<Integer> getNeighborsAndHidden(int node) {
    // {map(x->n2(x,G)[], n2(j,G))[]} minus {j};
    NavigableSet<Integer> neighborsAndMore = getDepartures(node);
    neighborsAndMore.addAll( getDepartures(neighborsAndMore) );
    neighborsAndMore.remove(node);
    return neighborsAndMore;
  }

  /**
   * hidden nodes of j in G (neighbors of neighbors minus neighbors minus j)
   * @param node
   * @return
   */
  public NavigableSet<Integer> getHidden(Integer node) {
    // h2 := (j,G) -> {map(x->n2(x,G)[], n2(j,G))[]} minus n2(j,G) minus {j};
    NavigableSet<Integer> stHidden = getNeighborsAndHidden(node);
    stHidden.removeAll(getDepartures(node));
    return stHidden;
  }

  /**
   * @return the adjacencyMatrix
   */
  public int[][] getAdjacencyMatrix() {
    return adjacencyMatrix;
  }

}
