package brn.analysis.dump;

public class IEEE80211Header {

  public static final int HEADER_SIZE = 32;
  public static final int OFFSET_ADDR1 = 4;
  public static final int OFFSET_ADDR2 = 10;
  public static final int OFFSET_ADDR3 = 16;

  public static byte[] getAddr1(byte[] msg, int offset) {
    if (msg.length < offset + 10)
      return null;
    byte[] ret = new byte[6];
    System.arraycopy(msg, offset + 4, ret, 0, 6);
    return ret;
  }

  public static byte[] getAddr2(byte[] msg, int offset) {
    if (msg.length <= offset + 16)
      return null;
    byte[] ret = new byte[6];
    System.arraycopy(msg, offset + 10, ret, 0, 6);
    return ret;
  }
}
