package brn.analysis.mcexor;

import jist.swans.net.NetAddress;

import java.util.List;
import java.util.ArrayList;

import brn.util.Tuple;

/**
 * Azu
 */
public class ImgCandidateSet {

  final static int MAX = 8;

  /** Matlab: nchoosek(2:1:8,1) */
  final static int[][] single = {
      {2},{3},{4},{5},{6},{7},{8}
  };

  final static int SINGLE_MAX = single.length;

  /** Matlab: nchoosek(2:1:8,2) */
  final static int[][] twin = {
      {2,3},{2,4},{2,5},{2,6},{2,7},{2,8},
      {3,4},{3,5},{3,6},{3,7},{3,8},
      {4,5},{4,6},{4,7},{4,8},
      {5,6},{5,7},{5,8},
      {6,7},{6,8},
      {7,8}};

  final static int TWIN_MAX = twin.length;

  /** Matlab: nchoosek(2:1:8,3) */
  final static int[][] triple = {
      {2,3,4},{2,3,5},{2,3,6},{2,3,7},{2,3,8},{2,4,5},{2,4,6},{2,4,7},{2,4,8},{2,5,6},{2,5,7},{2,5,8},{2,6,7},{2,6,8},{2,7,8},
      {3,4,5},{3,4,6},{3,4,7},{3,4,8},{3,5,6},{3,5,7},{3,5,8},{3,6,7},{3,6,8},{3,7,8},
      {4,5,6},{4,5,7},{4,5,8},{4,6,7},{4,6,8},{4,7,8},
      {5,6,7},{5,6,8},{5,7,8},
      {6,7,8}
  };

  final static int TRIPLE_MAX = triple.length;

  /** Matlab: nchoosek(2:1:8,4) */
  final static int[][] quad = {
      {2,3,4,5},{2,3,4,6},{2,3,4,7},{2,3,4,8},{2,3,5,6},{2,3,5,7},{2,3,5,8},{2,3,6,7},{2,3,6,8},{2,3,7,8},
      {2,4,5,6},{2,4,5,7},{2,4,5,8},{2,4,6,7},{2,4,6,8},{2,4,7,8},
      {2,5,6,7},{2,5,6,8},{2,5,7,8},{2,6,7,8},
      {3,4,5,6},{3,4,5,7},{3,4,5,8},{3,4,6,7},{3,4,6,8},{3,4,7,8},{3,5,6,7},{3,5,6,8},{3,5,7,8},{3,6,7,8},
      {4,5,6,7},{4,5,6,8},{4,5,7,8},{4,6,7,8},
      {5,6,7,8}
  };

  final static int QUAD_MAX = quad.length;

  public static String getSingleCsAsString(Integer idx) {
    return "[" + single[idx.intValue()][0] + "]";
  }

  public static List calculateSingleCs(Integer idx) {
    List r = new ArrayList();
    r.add(new NetAddress(single[idx.intValue()][0]));
    return r;
  }

  public static String getTwinCsAsString(Integer idx) {
    return "[" + twin[idx.intValue()][1] + "," + twin[idx.intValue()][0] +  "]";
  }

  public static List calculateTwinCs(Integer idx) {
    List r = new ArrayList();
    r.add(new NetAddress(twin[idx.intValue()][1]));
    r.add(new NetAddress(twin[idx.intValue()][0]));
    return r;
  }

  public static String getTripleCsAsString(Integer idx) {
    return "[" + triple[idx.intValue()][2] + "," + triple[idx.intValue()][1] + "," + triple[idx.intValue()][0] + "]";  
  }

  public static List calculateTripleCs(Integer idx) {
    List r = new ArrayList();
    r.add(new NetAddress(triple[idx.intValue()][2]));
    r.add(new NetAddress(triple[idx.intValue()][1]));
    r.add(new NetAddress(triple[idx.intValue()][0]));
    return r;
  }

  public static String getQuadCsAsString(Integer idx) {
    return "[" + quad[idx.intValue()][3] + ","
        + quad[idx.intValue()][2] + ","
        + quad[idx.intValue()][1] + ","
        + quad[idx.intValue()][0] + "]";
  }

  public static List calculateQuadCs(Integer idx) {
    List r = new ArrayList();
    r.add(new NetAddress(quad[idx.intValue()][3]));
    r.add(new NetAddress(quad[idx.intValue()][2]));
    r.add(new NetAddress(quad[idx.intValue()][1]));
    r.add(new NetAddress(quad[idx.intValue()][0]));
    return r;
  }
}
