package brn.analysis.mcexor;

import jist.swans.field.PathLoss;
import jist.swans.field.Fading;
import jist.swans.radio.RadioFactory;
import jist.swans.radio.RadioInfo;
import jist.swans.Constants;
import jist.swans.misc.Location;
import jist.swans.misc.Message;
import jist.runtime.JistAPI;

/**
 * Created by IntelliJ IDEA.
 * User: zubow
 * Date: 28.05.2007
 * Time: 14:14:27
 * To change this template use File | Settings | File Templates.
 */
public class TestPathlossEffects {

  public static void main(String[] args) {

    double exponent = 2.7;
    double stdDeviation = 4.0;
    double refDist = 1.0;
    long coherenceTime = 100;
    boolean symmetricShadowing = true;
    double quantile = 0.95;

    PathLoss.DistShadowing pl = new PathLoss.DistShadowing(exponent, stdDeviation,
        refDist, coherenceTime, 50, symmetricShadowing,
        quantile);

    Fading.Rayleigh fading = new Fading.Rayleigh();

    RadioInfo r1 = RadioFactory.createRadioInfoDefault(Constants.MAC_802_11b);

    Location l1 = new Location.Location2D(0, 0);
    Location l2 = new Location.Location2D(100, 0);

    while (true) {
      double loss = pl.compute(r1, l1, r1, l2);
      double fade = fading.compute();
      double dstPower = r1.getPower(Message.NULL) - loss + fade;

      System.out.println(JistAPI.getTime() + " loss = " + loss + " fading " + fade + " total: " + dstPower);
      JistAPI.sleep(10);
    }

  }
}
