package brn.sim;

import brn.sim.DataManager.DataContributor;
import brn.sim.data.PropertiesData;

import jist.swans.route.RouteAodv.AodvStats;

public class PropertiesContributor extends DataContributor {
  public static final String ID = "AodvStatsContributor";

  /* (non-Javadoc)
   * @see brn.sim.DataManager.DataContributor#getId()
   */
  public String getId() {
    return ID;
  }

  /**
   * Adds the given aodv stats to data manager.
   *
   * @param stats the stats to add.
   * @param path the path to use.
   */
  public void addProperites(AodvStats stats, String[] path) {
    addData(new PropertiesData(stats, path), DataManager.LEVEL_IMPORTANT);
  }
}
