package brn.sim.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

import jist.runtime.JistAPI;

public class CsvSerializer implements JistAPI.DoNotRewrite {

  /** value separator */
  private String vsep = ", ";
  
  /** line separator */
  private String lsep = System.getProperty("line.separator");

  private String content = "";

  public CsvSerializer(AbstractDiagramData data) {
    this.addPoints(data.getLine());
  }

  public String getContent() {
    return content;
  }

  public void saveToFile(String fileName) throws IOException {
    Writer writer = new BufferedWriter(new FileWriter(fileName));

    writer.write(getContent());
    writer.close();
  }

  public void addPoints(Line t) {
    double[] time = t.getX();
    double[] value = t.getY();
    StringBuilder builder = new StringBuilder();

    if (time.length <= 0 || value.length <= 0)
      return;

    for (int i = 0; i < time.length; i++) {
      builder.append(time[i]);
      builder.append(vsep);
      builder.append(value[i]);
      builder.append(lsep);
    }
    content += builder.toString();
  }

}
