package brn.sim.data;

import jist.swans.Constants;

public class DiagramData extends AbstractDiagramData {

  private static final long serialVersionUID = 1L;
  private DiagramData chain;

  /** ctor for hibernate */
  protected DiagramData() {}

  public DiagramData(String[] path,
      String xLabel, String xUnits, String yLabel, String yUnits, int style) {
    super(path, xLabel, xUnits, yLabel, yUnits, style);
  }


  public DiagramData(String[] path,
      String xLabel, String xUnits, String yLabel, String yUnits) {
    this(path, xLabel, xUnits, yLabel, yUnits, AbstractDiagramData.SOLID);
  }

  public DiagramData(Line line, String[] path,
      String xLabel, String xUnits, String yLabel, String yUnits) {
    this(line, path, xLabel, xUnits, yLabel, yUnits, AbstractDiagramData.SOLID);
  }

  public DiagramData(double[] x, double[] y, String[] path,
      String xLabel, String xUnits, String yLabel, String yUnits) {
    this(path, xLabel, xUnits, yLabel, yUnits, AbstractDiagramData.SOLID);
    for (int i = 0; i < x.length; i++)
      this.line.add(x[i], y[i]);
  }

  public DiagramData(Line line, String[] path,
      String xLabel, String xUnits, String yLabel, String yUnits, int style) {
    super(line, path, xLabel, xUnits, yLabel, yUnits, style);
  }

  // //////////////////////////////////////////////////////////////////////
  // Interface part
  //

  /**
   * Add new chained data.
   * @param chain the new one to set.
   * @return the old one, which was removed.
   */
  public DiagramData addChain(DiagramData chain) {
    DiagramData old = this.chain;
    this.chain = chain;
    return old;
  }

  // final to allow inlining
  public final void addNextTimePoint(long time, double y) {
    double x = time / (double) Constants.SECOND;

    if (active) {
      line.add(x, y);
//      if (this.shouldFireChanged)
//        this.fireChanged();
    }

    if (null != this.chain)
      this.chain.addNextPoint(x, y);
  }

  // final to allow inlining
  public final void addNextPoint(double x, double y) {
    if (active) {
      line.add(x, y);
//      if (this.shouldFireChanged)
//        this.fireChanged();
    }
    if (null != this.chain)
      this.chain.addNextPoint(x, y);
  }

}
