package brn.sim.data;

import java.io.Serializable;

import jist.swans.Constants;
import jist.swans.net.NetAddress;

public class FlowStats implements Serializable {
  public static final long serialVersionUID = 1L;

  protected NetAddress src;
  protected int srcPort;
  protected NetAddress dst;
  protected int dstPort;

  protected int sendPackets;
  protected long sendBits;
  protected int recvPackets;
  protected long recvBits;

  protected double start = -1.;
  protected double end;
  protected double avgThroughput;
  protected double minDelay = Long.MAX_VALUE;
  protected double maxDelay = Long.MIN_VALUE;
  protected double avgDelay = 0;
  protected double avgHopCount = .0;

  /** ctor for hibernate */
  protected FlowStats() {}

  public FlowStats(NetAddress src, int srcPort, NetAddress dst, int dstPort) {
    this.src = src;
    this.srcPort = srcPort;
    this.dst = dst;
    this.dstPort = dstPort;
  }

  public void packetSend(long time, long bits) {
    sendPackets++;
    sendBits += bits;

    if (this.start < 0)
      this.start = time / (double)Constants.SECOND;
  }

  public void packetRecv(long time, long bits, long delay, int hopCount) {
    end = time / (double)Constants.SECOND;
    recvPackets++;
    recvBits += bits;

    avgThroughput = recvBits / (double)(end - start);

    double d = delay / (double)Constants.SECOND;
    avgDelay = (avgDelay * (recvPackets-1) + d) / recvPackets;
    minDelay = Math.min(minDelay, d);
    maxDelay = Math.max(maxDelay, d);

    avgHopCount = (avgHopCount * (recvPackets-1) + hopCount) / recvPackets;
  }

  /**
   * @return the avgDelay
   */
  public double getAvgDelay() {
    return avgDelay;
  }

  /**
   * @return the avgThroughput
   */
  public double getAvgThroughput() {
    return avgThroughput;
  }

  /**
   * @return the dst
   */
  public NetAddress getDst() {
    return dst;
  }

  /**
   * @return the dstPort
   */
  public int getDstPort() {
    return dstPort;
  }

  /**
   * @return the end
   */
  public double getEnd() {
    return end;
  }

  /**
   * @return the maxDelay
   */
  public double getMaxDelay() {
    return maxDelay;
  }

  /**
   * @return the minDelay
   */
  public double getMinDelay() {
    return minDelay;
  }

  /**
   * @return the recvBits
   */
  public long getRecvBits() {
    return recvBits;
  }

  /**
   * @return the recvPackets
   */
  public int getRecvPackets() {
    return recvPackets;
  }

  /**
   * @return the sendBits
   */
  public long getSendBits() {
    return sendBits;
  }

  /**
   * @return the sendPackets
   */
  public int getSendPackets() {
    return sendPackets;
  }

  /**
   * @return the src
   */
  public NetAddress getSrc() {
    return src;
  }

  /**
   * @return the srcPort
   */
  public int getSrcPort() {
    return srcPort;
  }

  /**
   * @return the start
   */
  public double getStart() {
    return start;
  }

  /**
   * @return the avgHopCount
   */
  public double getAvgHopCount() {
    return avgHopCount;
  }


}
