package brn.sim.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import brn.sim.DriverRemote;
import brn.sim.DataManager.DataContribution;

import jist.swans.net.NetAddress;

public class ForwardGraphData implements Serializable, DataContribution {
  private static final long serialVersionUID = 1L;

  // ////////////////////////////////////////////////
  // helper classes
  //

  public static class Node implements Serializable {
    private static final long serialVersionUID = 1L;

    public NetAddress addr;
    public int nodeId;
    public float locX;
    public float locY;

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
      return String.valueOf(nodeId);
    }

    /** ctor for hibernate */
    protected Node() {}

    public Node(NetAddress addr, int nodeId, float locX, float locY) {
      super();
      this.addr = addr;
      this.nodeId = nodeId;
      this.locX = locX;
      this.locY = locY;
    }

    public int hashCode() {
      final int PRIME = 31;
      int result = 1;
      result = PRIME * result + nodeId;
      return result;
    }

    public boolean equals(Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      final Node other = (Node) obj;
      if (nodeId != other.nodeId)
        return false;
      return true;
    }
  }

  public static class FwdLink implements Serializable {
    private static final long serialVersionUID = 1L;

    public Node from;
    public Node to;
    public int fromCh;
    public int toCh;
    public int flowId;
    public int noPackets;
    public int noDuplicates;

    /** ctor for hibernate */
    protected FwdLink() {}

    public FwdLink(Node from, int fromCh, Node to, int toCh, int flowId) {
      this.from = from;
      this.fromCh = fromCh;
      this.to = to;
      this.toCh = toCh;
      this.flowId = flowId;
      this.noPackets = 0;
      this.noDuplicates = 0;
    }

    public String getFromStr() {
      return from + ":" + fromCh;
    }

    public String getToStr() {
      return to + ":" + toCh;
    }

    public void incNoPackets() {
      this.noPackets++;
    }

    public void incNoDuplicates() {
      this.noDuplicates++;
    }

    public int hashCode() {
      final int PRIME = 31;
      int result = 1;
      result = PRIME * result + flowId;
      result = PRIME * result + ((from == null) ? 0 : from.hashCode());
      result = PRIME * result + fromCh;
      result = PRIME * result + ((to == null) ? 0 : to.hashCode());
      result = PRIME * result + toCh;
      return result;
    }

    public boolean equals(Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      final FwdLink other = (FwdLink) obj;
      if (flowId != other.flowId)
        return false;
      if (from == null) {
        if (other.from != null)
          return false;
      } else if (!from.equals(other.from))
        return false;
      if (fromCh != other.fromCh)
        return false;
      if (to == null) {
        if (other.to != null)
          return false;
      } else if (!to.equals(other.to))
        return false;
      if (toCh != other.toCh)
        return false;
      return true;
    }
  }

  // ////////////////////////////////////////////////
  // locals
  //

  public Map fwdLinks = new HashMap();

  public Map nodes = new HashMap();


  // ////////////////////////////////////////////////
  // Initialization
  //

  public ForwardGraphData() {
  }


  // ////////////////////////////////////////////////
  // access
  //

  public Map getLinks() {
    return fwdLinks;
  }

  public Map getNodes() {
    return nodes;
  }

  public Collection getLinksCollection() {
    return fwdLinks.values();
  }

  public Collection getNodesCollection() {
    return nodes.values();
  }


  public String[] getPath() {
    return new String[] {"Global", "Forward Graph"};
  }


  public int getType() {
    return DriverRemote.ITEM_TYPE_FWDGRAPH;
  }
  
  /*
   * (non-Javadoc)
   * @see brn.sim.DataManager.DataContribution#setActive(boolean)
   */
  public void setActive(boolean active) {
  }

}
