package brn.sim.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;


import jist.runtime.JistAPI;
import jist.runtime.Util;

public class GnuPlotSerializer implements JistAPI.DoNotRewrite {

  private String title;

  private String contentData;

  private String contentPlot;

  private boolean empty = true;

  private String[] path;

  private String subTitle;

  private String xLabel;

  private String xUnits;

  private String yLabel;

  private String yUnits;

  private String style;

  public GnuPlotSerializer(AbstractDiagramData data, String color) {
//    xAxisType = "double";
//    yAxisType = "double";
    this.title = data.getTitle();
    empty = true;

    this.path = data.getPath();
    this.subTitle = data.getSubTitle();
    this.xLabel = data.getXLabel();
    this.xUnits = data.getXUnits();
    this.yLabel = data.getYLabel();
    this.yUnits = data.getYUnits();
    this.style = (data.getStyle() == AbstractDiagramData.MARK) ? "points" : "lines";

    this.addLine(data.getLine(), color);
  }

  public void addLine(Line line, String color) {
    Util.assertion(empty() == true);
    double[] xArray = line.getX();
    double[] yArray = line.getY();

    StringBuilder builder = new StringBuilder();
    for (int i = 0; i < xArray.length; i++) {
      builder.append(xArray[i]);
      builder.append('\t');
      builder.append(yArray[i]);
      builder.append('\n');
    }
    contentData += builder.toString();

    builder = new StringBuilder();
    builder.append("set terminal png\n");
    builder.append("set title \"[").append(path).append("] ").
      append(line.getTitle()).append("\\n").append(subTitle).append("\"\n");
    builder.append("set xlabel \"").append(xLabel).append(" (").append(xUnits).
      append(")").append("\"\n");
    builder.append("set ylabel \"").append(yLabel).append(" (").append(yUnits).
      append(")").append("\"\n");
    contentPlot += builder.toString();


    empty = false;
  }

  public void saveToFile(String dataFile, String plotFile) throws IOException {
    saveDataFile(dataFile);
    savePlotFile(plotFile, dataFile);
  }

  protected void saveDataFile(String dataFile) throws IOException {
    if (empty())
      return;

    // Write the data
    Writer writer = new BufferedWriter(new FileWriter(dataFile));

    writer.write(contentData);
    writer.close();
  }

  protected void savePlotFile(String fileName, String data) throws IOException {
    if (empty())
      return;

    String dataFile = data.replace('\\', '/');

    StringBuilder builder = new StringBuilder();
    builder.append("plot \"").append(dataFile).append("\" with ").append(style).
      append(" title \"").append(yLabel).append("\" \n");
    contentPlot += builder.toString();

    // Write the data
    Writer writer = new BufferedWriter(new FileWriter(fileName));

    writer.write(contentPlot);
    writer.close();
  }

  private boolean empty() {
    return empty;
  }

  public String getTitle() {
    return title;
  }

}
