package brn.sim.data;

import java.io.Serializable;

import jist.runtime.Main;
import jist.runtime.Util;

public class Line implements Serializable {

  private static final long serialVersionUID = 1L;

  private double[] xValue;
  private double[] yValue;
  private int next = 0;

  private String title;

  /** ctor for hibernate */
  protected Line() {}

  public Line(String title) {
    xValue = new double[8];
    yValue = new double[xValue.length];
    next = 0;

    this.title = title;
  }

  public void add(double x, double y) {
    try {
      this.xValue[next] = x;
      this.yValue[next] = y;
      next++;
    }
    catch (ArrayIndexOutOfBoundsException e) {
      if (Main.ASSERT)
        Util.assertion(this.xValue.length > 4);
      double[] l = this.xValue;
      int newLen = Math.max(l.length*2, 8);
//      while (newLen <= next)
//        newLen *= 2;
      this.xValue = new double[newLen];
      System.arraycopy(l, 0, this.xValue, 0, l.length);

      double[] d = this.yValue;
      this.yValue = new double[this.xValue.length];
      System.arraycopy(d, 0, this.yValue, 0, d.length);

      try {
        this.xValue[next] = x;
        this.yValue[next] = y;
        next++;
      }
      catch (ArrayIndexOutOfBoundsException e1) {
        throw new RuntimeException(e1);
      }
    }
  }

  public void trim() {
    double[] l = this.xValue;
    this.xValue = new double[Math.max(next, 8)];
    System.arraycopy(l, 0, this.xValue, 0, this.xValue.length);

    double[] d = this.yValue;
    this.yValue = new double[this.xValue.length];
    System.arraycopy(d, 0, this.yValue, 0, this.yValue.length);
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public double[] getX() {
    double[] ret = new double[next];
    System.arraycopy(xValue, 0, ret, 0, next);
    return ret;
  }

  public double[] getY() {
    double[] ret = new double[next];
    System.arraycopy(yValue, 0, ret, 0, next);
    return ret;
  }

  public boolean empty() {
    return (next <= 0);
  }

  public int getLengthInternal() {
    return next;
  }

  public double[] getYInternal() {
    return yValue;
  }

  public double[] getXInternal() {
    return xValue;
  }

}
