/**
 *
 */
package brn.sim.data;

import java.io.Serializable;
import java.util.List;

import brn.sim.DriverRemote;
import brn.sim.DataManager.DataContribution;
import brn.swans.route.metric.LinkTable;

/**
 * @author kurth
 *
 */
public class LinkTableData implements Serializable, DataContribution {

  public static class Node implements Serializable {
    private static final long serialVersionUID = 1L;

    public int nodeId;
    public float locX;
    public float locY;

    /** ctor for hibernate */
    protected Node() {}

    public Node(int nodeId, float x, float y) {
      this.nodeId = nodeId;
      this.locX = x;
      this.locY = y;
    }

    public int hashCode() {
      final int PRIME = 31;
      int result = 1;
      result = PRIME * result + nodeId;
      return result;
    }

    public boolean equals(Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      final Node other = (Node) obj;
      if (nodeId != other.nodeId)
        return false;
      return true;
    }
  }

  public static class Link implements Serializable  {
    private static final long serialVersionUID = 1L;

    protected Object from;

    protected Object to;

    protected int metric;

    protected long seq;

    protected Link() {}

    public Link(Object from, Object to, int metric, long seq) {
      super();
      this.from = from;
      this.to = to;
      this.metric = metric;
      this.seq = seq;
    }

    public Link(LinkTable.LinkData linkInfo) {
      this.from = linkInfo.from();
      this.to = linkInfo.to();
      this.metric = linkInfo.metric();
      this.seq = linkInfo.seq();
    }

    public String toString() {
      return from + " -> " + to + " : " + metric;
    }

    /**
     * @return the from
     */
    public Object getFrom() {
      return from;
    }

    /**
     * @param from the from to set
     */
    public void setFrom(Object from) {
      this.from = from;
    }

    /**
     * @return the metric
     */
    public int getMetric() {
      return metric;
    }

    /**
     * @param metric the metric to set
     */
    public void setMetric(int metric) {
      this.metric = metric;
    }

    /**
     * @return the seq
     */
    public long getSeq() {
      return seq;
    }

    /**
     * @param seq the seq to set
     */
    public void setSeq(long seq) {
      this.seq = seq;
    }

    /**
     * @return the to
     */
    public Object getTo() {
      return to;
    }

    /**
     * @param to the to to set
     */
    public void setTo(Object to) {
      this.to = to;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
      final int PRIME = 31;
      int result = 1;
      result = PRIME * result + ((from == null) ? 0 : from.hashCode());
      result = PRIME * result + (int)seq;
      result = PRIME * result + ((to == null) ? 0 : to.hashCode());
      return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      final Link other = (Link) obj;
      if (from == null) {
        if (other.from != null)
          return false;
      } else if (!from.equals(other.from))
        return false;
      if (seq != other.seq)
        return false;
      if (to == null) {
        if (other.to != null)
          return false;
      } else if (!to.equals(other.to))
        return false;
      return true;
    }
  }

  private static final long serialVersionUID = 1L;

  /** id of the node */
  private int nodeId;

  /** list of all nodes */
  private List /*List<LinkTableData.Node>*/ nodes;

  /* list of all links the specified node has */
  private List /*List<LinkTableData.Link>*/ links;

  private String[] path;

  /** ctor for hibernate */
  protected LinkTableData() {}

  public LinkTableData(int nodeId, List nodes, List links) {
    this.nodeId = nodeId;
    this.nodes = nodes;
    this.links = links;
    this.path = new String[] {"Node "+ nodeId, "Links", "Link Table"};
  }

  /**
   * @return the links
   */
  public List getLinks() {
    return links;
  }

  /**
   * @return the nodes
   */
  public List getNodes() {
    return nodes;
  }

  /**
   * @return the nodeId
   */
  public int getNodeId() {
    return nodeId;
  }

  public String[] getPath() {
    return path;
  }

  public int getType() {
    return DriverRemote.ITEM_TYPE_LINKTABLE;
  }

  /*
   * (non-Javadoc)
   * @see brn.sim.DataManager.DataContribution#setActive(boolean)
   */
  public void setActive(boolean active) {
  }

}
