package brn.sim.data;

import java.io.Serializable;

public class MacStats implements Serializable {
  public static final long serialVersionUID = 1L;

//  /** address of the node */
//  protected MacAddress addr;

  /** number of sent rts packets */
  protected int rtsSend;
  /** number of received rts packets */
  protected int rtsRecv;

  /** number of sent cts packets */
  protected int ctsSend;
  /** number of received cts packets */
  protected int ctsRecv;

  /** number of sent unicast packets */
  protected int unicastSend;
  /** number of received unicast packets */
  protected int unicastRecv;

  /** number of sent broadcast packets */
  protected int broadcastSend;
  /** number of received broadcast packets */
  protected int broadcastRecv;

  /** number of sent ack packets */
  protected int ackSend;
  /** number of received ack packets */
  protected int ackRecv;

  public MacStats() {
//    this.addr = addr;
  }

  /**
   * @return the ackRecv
   */
  public int getAckRecv() {
    return ackRecv;
  }

  /**
   * @return the ackSend
   */
  public int getAckSend() {
    return ackSend;
  }

//  /**
//   * @return the addr
//   */
//  public MacAddress getAddr() {
//    return addr;
//  }

  /**
   * @return the broadcastRecv
   */
  public int getBroadcastRecv() {
    return broadcastRecv;
  }

  /**
   * @return the broadcastSend
   */
  public int getBroadcastSend() {
    return broadcastSend;
  }

  /**
   * @return the ctsRecv
   */
  public int getCtsRecv() {
    return ctsRecv;
  }

  /**
   * @return the ctsSend
   */
  public int getCtsSend() {
    return ctsSend;
  }

  /**
   * @return the rtsRecv
   */
  public int getRtsRecv() {
    return rtsRecv;
  }

  /**
   * @return the rtsSend
   */
  public int getRtsSend() {
    return rtsSend;
  }

  /**
   * @return the unicastRecv
   */
  public int getUnicastRecv() {
    return unicastRecv;
  }

  /**
   * @return the unicastSend
   */
  public int getUnicastSend() {
    return unicastSend;
  }

  // final to allow inlining
  public final void incAckRecv() {
    ackRecv++;
  }

  // final to allow inlining
  public final void incAckSend() {
    ackSend++;
  }

  // final to allow inlining
  public final void incBroadcastRecv() {
    broadcastRecv++;
  }

  // final to allow inlining
  public final void incBroadcastSend() {
    broadcastSend++;
  }

  // final to allow inlining
  public final void incCtsRecv() {
    ctsRecv++;
  }

  // final to allow inlining
  public final void incCtsSend() {
    ctsSend++;
  }

  // final to allow inlining
  public final void incRtsRecv() {
    rtsRecv++;
  }

  // final to allow inlining
  public final void incRtsSend() {
    rtsSend++;
  }

  // final to allow inlining
  public final void incUnicastRecv() {
    unicastRecv++;
  }

  // final to allow inlining
  public final void incUnicastSend() {
    unicastSend++;
  }
}
