package brn.sim.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import brn.sim.DriverRemote;
import brn.sim.DataManager.DataContribution;

public class TimeBar implements DataContribution, Serializable {

  // ////////////////////////////////////////////////
  // constants
  //

  private static final long serialVersionUID = 1L;

  /**
   * Default color white (value is 1).
   */
  public static final byte COLOR_WHITE = 1;

  /**
   * Default color black (value is 2).
   */
  public static final byte COLOR_BLACK = 2;

  /**
   * Default color red (value is 3).
   */
  public static final byte COLOR_RED = 3;

  /**
   * Default color dark red (value is 4).
   */
  public static final byte COLOR_DARK_RED = 4;

  /**
   * Default color green (value is 5).
   */
  public static final byte COLOR_GREEN = 5;

  /**
   * Default color dark green (value is 6).
   */
  public static final byte COLOR_DARK_GREEN = 6;

  /**
   * Default color yellow (value is 7).
   */
  public static final byte COLOR_YELLOW = 7;

  /**
   * Default color dark yellow (value is 8).
   */
  public static final byte COLOR_DARK_YELLOW = 8;

  /**
   * Default color blue (value is 9).
   */
  public static final byte COLOR_BLUE = 9;

  /**
   * Default color dark blue (value is 10).
   */
  public static final byte COLOR_DARK_BLUE = 10;

  /**
   * Default color magenta (value is 11).
   */
  public static final byte COLOR_MAGENTA = 11;

  /**
   * Default color dark magenta (value is 12).
   */
  public static final byte COLOR_DARK_MAGENTA = 12;

  /**
   * Default color cyan (value is 13).
   */
  public static final byte COLOR_CYAN = 13;

  /**
   * Default color dark cyan (value is 14).
   */
  public static final byte COLOR_DARK_CYAN = 14;

  /**
   * Default color gray (value is 15).
   */
  public static final byte COLOR_GRAY = 15;

  /**
   * Default color dark gray (value is 16).
   */
  public static final byte COLOR_DARK_GRAY = 16;


  // ////////////////////////////////////////////////
  // nested classes
  //

  public static class Entry implements Serializable {
    private static final long serialVersionUID = 1L;

    public long start;
    public long end;
    public int nodeId;
    public byte color;
    public String text;
    public String detail;

    /** ctor for hibernate */
    protected Entry() {}

    public Entry(int nodeId, long start, long end, byte color, String text, String detail) {
      this.start = start;
      this.end = end;
      this.nodeId = nodeId;
      this.color = color;
      this.text = text;
      this.detail = detail;
    }

//    public Entry(int nodeId, long start, long end, byte color, String text) {
//      this(nodeId, start, end, color, text, null);
//    }
  }


  // ////////////////////////////////////////////////
  // locals
  //

  protected String[] path;

  protected List /*Entry*/ entries;


  // ////////////////////////////////////////////////
  // initialization
  //

  /** ctor for hibernate */
  protected TimeBar() {}

  public TimeBar(String[] path) {
    this.path = path;
    this.entries = new ArrayList();
  }


  // ////////////////////////////////////////////////
  // implementation
  //

  /*
   * (non-Javadoc)
   * @see brn.sim.DataManager.DataContribution#getType()
   */
  public int getType() {
    return DriverRemote.ITEM_TYPE_TIMEBAR;
  }

  /*
   * (non-Javadoc)
   * @see brn.sim.DataManager.DataContribution#getPath()
   */
  public String[] getPath() {
    return path;
  }

  /*
   * (non-Javadoc)
   * @see brn.sim.DataManager.DataContribution#setActive(boolean)
   */
  public void setActive(boolean active) {
    // TODO
  }

  /**
   * @return the entries
   */
  public List getEntries() {
    return entries;
  }

  /**
   * Add a timebar entry.
   *
   * @param nodeId node id.
   * @param start start time.
   * @param end end time.
   * @param color color to use.
   * @param text text to display within the timebar.
   */
  public void add(int nodeId, long start, long end, byte color, String text) {
    entries.add(new Entry(nodeId, start, end, color, text, null));
  }

  /**
   * Add a timebar entry.
   *
   * @param nodeId node id.
   * @param start start time.
   * @param end end time.
   * @param color color to use.
   * @param text text to display within the timebar.
   * @param detail text to display in properties view
   */
  public void add(int nodeId, long start, long end, byte color, String text, String detail) {
    entries.add(new Entry(nodeId, start, end, color, text, detail));
  }

  public void add(Entry entry) {
    entries.add(entry);
  }
}
