package brn.sim.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

import jist.runtime.JistAPI;

public class XplotSerializer implements JistAPI.DoNotRewrite {

  public static final String white = "white";
  public static final String green = "green";
  public static final String red = "red";
  public static final String blue="blue";
  public static final String yellow="yellow";
  public static final String purple="purple";
  public static final String orange="orange";
  public static final String magenta="magenta";
  public static final String pink="pink";
  public static final String gray20="gray20";


  private String title;

  private String content;

  private String xAxisType;

  private String yAxisType;

  private boolean empty = true;

  public XplotSerializer(String title, String xlabel, String ylabel) {
    xAxisType = "double";
    yAxisType = "double";
    this.title = title;
    empty = true;

    content = xAxisType + " " + yAxisType + "\ntitle\n" + title + "\nxlabel\n"
        + xlabel + "\nylabel\n" + ylabel + "\n";
  }

  public XplotSerializer(AbstractDiagramData data, String color) {
    xAxisType = "double";
    yAxisType = "double";
    this.title = data.getTitle();
    empty = true;

    content = xAxisType + " " + yAxisType + "\ntitle\n" + title + "\nxlabel\n"
        + data.getXLabel() + "\nylabel\n" + data.getYLabel() + "\n";

    if (data.getStyle() == AbstractDiagramData.MARK)
      this.addPoints(data.getLine(), color);
    else
      this.addLine(data.getLine(), color);
  }

  public void add(Line t, String color) {
    if (t.empty())
      return;
    addLine(t, color);
    empty = false;
  }

  public void addLine(Line t, String color) {
    if (t.empty())
      return;

    empty = false;
    double[] time = t.getX();
    double[] value = t.getY();
    StringBuilder builder = new StringBuilder();
    String scolor = " " + color + "\n";

    if (time.length <= 0 || value.length <= 0)
      return;

    builder.append("ltext ");
    builder.append(time[0]);
    builder.append(" ");
    builder.append(value[0]);
    builder.append(scolor);
    builder.append(t.getTitle());
    builder.append("\n");

    for (int i = 1; i < time.length; i++) {
      builder.append("line ");
      builder.append(time[i - 1]);
      builder.append(" ");
      builder.append(value[i - 1]);
      builder.append(" ");
      builder.append(time[i]);
      builder.append(" ");
      builder.append(value[i]);
      builder.append(scolor);
    }
    content += builder.toString();
  }

  public void addPoints(Line t, String color) {
    if (t.empty())
      return;

    empty = false;
    this.addPoints(t, color, "dot");
  }

  /**
   *
   *
   * x dot plus box diamond utick dtick ltick rtick htick vtick uarrow darrow
   * larrow rarrow
   *
   * @param t
   * @param color
   * @param shape
   */
  public void addPoints(Line t, String color, String shape) {
    if (t.empty())
      return;

    empty = false;
    double[] time = t.getX();
    double[] value = t.getY();
    StringBuilder builder = new StringBuilder();
    String scolor = " " + color + "\n";

    if (time.length <= 0 || value.length <= 0)
      return;

    builder.append("ltext ");
    builder.append(time[0]);
    builder.append(" ");
    builder.append(value[0]);
    builder.append(scolor);
    builder.append(t.getTitle());
    builder.append("\n");

    for (int i = 0; i < time.length; i++) {
      builder.append(shape);
      builder.append(" ");
      builder.append(time[i]);
      builder.append(" ");
      builder.append(value[i]);
      builder.append(scolor);
    }
    content += builder.toString();
  }

  public String getContent() {
    return content;
  }

  public void saveToFile(String fileName) throws IOException {
    if (empty())
      return;

    Writer writer = new BufferedWriter(new FileWriter(fileName));

    writer.write(getContent());
    writer.close();
  }

  private boolean empty() {
    return empty;
  }

  public String getTitle() {
    return title;
  }
}
