package brn.sim.data.gantt;

import jist.swans.radio.AbstractRadio;

import java.util.Hashtable;

public class ChannelTraceEvent extends TraceEvent {

  private Hashtable lastEventTime = new Hashtable();
  private AbstractRadio.RadioChannelStartSwitchEvent curr_ev = null;

  public void set(AbstractRadio.RadioChannelStartSwitchEvent ev) {
    this.curr_ev = ev;
  }

  public String showYourself() {

    StringBuilder builder = new StringBuilder();

    // Syntax: time, node_id, old mode, new mode
    builder.append(curr_ev.time/* / (float) Constants.SECOND*/);
    builder.append(",");
    builder.append(curr_ev.nodeId);
    builder.append(",");
    builder.append(curr_ev.oldChannel.getChannel());
    builder.append(",");
    builder.append(curr_ev.newChannel.getChannel());
    builder.append(",");

    Object lastTime = lastEventTime.get(new Integer(curr_ev.nodeId));
    if (lastTime == null) {
      lastEventTime.put(new Integer(curr_ev.nodeId), new Long(0));
      lastTime = lastEventTime.get(new Integer(curr_ev.nodeId));
    }


    long duration = curr_ev.time - ((Long)lastTime).longValue();

    builder.append(duration);

    lastEventTime.put(new Integer(curr_ev.nodeId), new Long(curr_ev.time));

    return builder.toString();
  }

}
