package brn.sim.data.gantt;

import jist.swans.mac.AbstractMac;

import java.util.Hashtable;

public class RadioModeTraceEvent extends TraceEvent {

  private Hashtable lastEventTime = new Hashtable();
  private AbstractMac.RadioModeChanged curr_ev = null;

  public void set(AbstractMac.RadioModeChanged ev) {
    this.curr_ev = ev;
  }

  public String showYourself() {

    StringBuilder builder = new StringBuilder();

    // Syntax: time, node_id, old mode, new mode
    builder.append(curr_ev.time/* / (float) Constants.SECOND*/);
    builder.append(",");
    builder.append(curr_ev.nodeId);
    builder.append(",");
    builder.append(curr_ev.oldMode);
    builder.append(",");
    builder.append(curr_ev.newMode);
    builder.append(",");

    Object lastTime = lastEventTime.get(new Integer(curr_ev.nodeId));
    if (lastTime == null) {
      lastEventTime.put(new Integer(curr_ev.nodeId), new Long(0));
      lastTime = lastEventTime.get(new Integer(curr_ev.nodeId));
    }


    long duration = curr_ev.time - ((Long)lastTime).longValue();

    builder.append(duration);

    lastEventTime.put(new Integer(curr_ev.nodeId), new Long(curr_ev.time));

    return builder.toString();
  }

}
