package brn.sim.data.gantt;

import java.io.IOException;

/**
 */
public abstract class Trace {

    /**
     * Write the leading section of the output ...
     */
    public abstract void writePreamble() throws IOException;

    /**
     * Handle an event. The way an event from the simulator is handled depends
     * entirely on the subclass.
     */
    public abstract void handleEvent(TraceEvent e) throws IOException;

    /**
     * Write any trailing output that has to be written. Useful if a given
     * file-format has to be used.
     */
    public abstract void writePostamble() throws IOException;
}
