package brn.sim.data.javis;

import jist.swans.Constants;

public class DequeueTraceEvent extends TraceEvent {

  private long sourceID;

  private long destinationID;

  private short packetType;

  private int sizeOfPacket;

  private int packetAttribute = 0; // used as color id

  private int packetID;

  private int queueLength;

  public void set(long time, long SrcID, long destID, short pcktType,
      int sizeOfPacket, int pcktID, int queueLength) {
    this.sourceID = SrcID;
    this.destinationID = destID;
    this.packetType = pcktType;
    this.sizeOfPacket = sizeOfPacket;
    this.packetID = pcktID;
    this.queueLength = queueLength;
    this.time = time;
  }

  public String showYourself() {

    StringBuilder builder = new StringBuilder();

    builder.append("- -t ");
    builder.append(time / (float) Constants.SECOND);
    // builder.append( "n -t " + "*" + " ");
    builder.append(" -s ");
    builder.append(this.sourceID);
    builder.append(" -d ");
    builder.append(this.destinationID);
    builder.append(" -p ");
    builder.append(getProtocolName(this.packetType));
    builder.append(" -e ");
    builder.append(this.sizeOfPacket);
    builder.append(" -i ");
    builder.append(this.packetID);
    // builder.append("-c " + "2 ");
    builder.append(" -a ");
    builder.append(this.packetAttribute);

    return builder.toString();
  }

  public long getDestinationID() {
    return destinationID;
  }

  public int getPacketAttribute() {
    return packetAttribute;
  }

  public int getPacketID() {
    return packetID;
  }

  public short getPacketType() {
    return packetType;
  }

  public int getSizeOfPacket() {
    return sizeOfPacket;
  }

  public long getSourceID() {
    return sourceID;
  }

  public int getQueueLength() {
    return queueLength;
  }

}
