/*
 * Created on 20/10/2005
 * @author Gabi Kliot
 */
package brn.sim.data.javis;


import java.io.IOException;
import java.util.zip.GZIPOutputStream;

import jist.runtime.JistAPI;

/**
 * The actual Javis trace class. It is bundeled to an output file upon creation
 * and handles TraceEvents during the simulation.
 */
public class JavisTrace extends Trace implements JistAPI.DoNotRewrite {

  private java.io.BufferedWriter m_writer;

  /**
   * Create a new Javis guiTrace object that will write to the file with the
   * supplied name. If the name ends with ".gz", then the output will be written
   * in compressed form (Javis is capable of reading compressed input, NAM
   * isn't, so beware). Compressed output is recommended because guiTrace-files
   * do get big.
   */
  public JavisTrace(String filename) throws IOException {
    super();

    if (filename.endsWith(".gz")) {
      m_writer = new java.io.BufferedWriter(new java.io.OutputStreamWriter(
          new GZIPOutputStream(new java.io.FileOutputStream(filename))));
    } else {
      m_writer = new java.io.BufferedWriter(new java.io.OutputStreamWriter(
          new java.io.FileOutputStream(filename)));
    }
  }

  public synchronized void writePreamble(int xAxis, int yAxis)
      throws IOException {
    // Write a little comment at the beginning
//    m_writer.write("# Trace file generated by Jist/Swans Version " + "1.0.6."
//        + " at " + (new Date()));
//    m_writer.newLine();
    m_writer.write("V -t * -v 1.0a5 -a 0");
    m_writer.newLine();

    m_writer.write("W -t * -x " + xAxis + " -y " + yAxis);
    m_writer.newLine();

    m_writer.write("A -t * -n 1 -p 0 -o 0xffffffff -c 31 -a 1");
    m_writer.newLine();
    m_writer.write("A -t * -h 1 -m 2147483647 -s 0");
    m_writer.newLine();
  }

  public synchronized void handleEvent(TraceEvent e) throws IOException {
    String s = e.showYourself();

    // System.out.println(s);

    m_writer.write(s);
    m_writer.newLine();

  }

  public synchronized void writePostamble() throws IOException {
    m_writer.close();
  }

  public static Trace createTrace(String fileName) {
    Trace trace = null;

    //Wireless Range of mobile or static radios in this simulation environment
    int wirelessRangeX = 410;
    int wirelessRangeY = 410;

    try {
      trace = new JavisTrace(fileName);
      trace.writePreamble(wirelessRangeX, wirelessRangeY);

    } catch (IOException e) {
      System.out.println("Could not create TraceFile!");
    }

    ShutdownHook.installHook(trace);
    return trace;
  }

  /**
   * Shutdown hook, closes the output file.
   *
   */
  public static class ShutdownHook implements Runnable {
    Trace trace;

    public ShutdownHook(Trace trace) {
      this.trace = trace;
    }

    public void run() {
      try {
        trace.writePostamble();
      } catch (IOException e) {
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
    }

    public static void installHook(Trace trace) {
      JistAPI.runAt(new ShutdownHook(trace), JistAPI.END);
    }
  }

  // public static void JavisTrace.drawGuiTrace(Field f) {
  // try {
  // f.snapShot2Trace();
  // } catch (IOException e) {
  // System.out.println("Could not create TraceFile!");
  // }
  // }

}
