package brn.sim.data.javis;

import jist.swans.Constants;

public class MarkTraceEvent extends TraceEvent {

  public final static String COLOR_RED      = "red";
  public final static String COLOR_BLUE     = "blue";
  public final static String COLOR_GREEN    = "green";
  public final static String COLOR_BLACK    = "black";

  public final static String SHAPE_CIRCLE   = "circle";
  public final static String SHAPE_SQUARE   = "square";
  public final static String SHAPE_HEXAGON  = "hexagon";

  private String name;
  private long sourceID;
  private String color;
  private String shape;
  private boolean removeMark;

  public void set(long time, String name, long sourceID, int color, String shape, boolean removeMark) {
    this.time = time;
    this.sourceID = sourceID;
    switch (color) {
      case 1:
        this.color = COLOR_RED;
        break;
      case 2:
        this.color = COLOR_BLUE;
        break;
      case 3:
        this.color = COLOR_GREEN;
        break;
      default:
        this.color = COLOR_BLACK;
    }
    this.shape = shape;
    this.name = name;
    this.removeMark = removeMark;
  }

  public String showYourself() {

    StringBuilder builder = new StringBuilder();

    builder.append("m -t ");
    builder.append(time / (float) Constants.SECOND);
    //builder.append( "n -t " + "*" + " ");
    builder.append(" -s ");
    builder.append(this.sourceID);
    builder.append(" -n ");
    builder.append(this.name);
    builder.append(" -c ");
    builder.append(this.color);
    builder.append(" -h ");
    builder.append(this.shape);

    if (this.removeMark)
      builder.append(" -X ");

    return builder.toString();
  }

}
