/*
 * Created on 20/10/2005
 * @author Gabi Kliot
 */

package brn.sim.data.javis;

import jist.swans.Constants;
import jist.swans.misc.Location;

/**
 * A trace event representing a single node: radioId and its location in the Field
 */
public class NodeTraceEvent extends TraceEvent {
  private Location loc;

  private long radioId;

  public void set(long time, Location loc, long radioId) {
    this.loc = loc;
    this.radioId = radioId;
    this.time = time;
  }

  public void set(Location loc, int radioId) {
    this.set(-1, loc, radioId);
  }

  /* (non-Javadoc)
   * @see guiTrace.TraceEvent#showYourself()
   */
  //n -t * -a 20 -s 20 -S UP -v circle -c black -x 496.80377 -y 207.64095
  public String showYourself() {
    // Current implementation of Javis does not support -t
    //System.out.printf("%.3f\n",(double)(getTime()/(float)Constants.SECOND));

    //int z = (int)(100000.0*(double)(getTime()/(float)Constants.SECOND));
    //System.out.println("Sayi: "+ z);
    //double v =(double) z / 100000.0;
    //System.out.println("Sayi2: "+ v);

    StringBuilder builder = new StringBuilder();

    builder.append("n -t ");
    builder.append((time >= 0 ? time / (float) Constants.SECOND + " "
        : "* "));
    //builder.append( "n -t " + "*" + " ");
    builder.append(" -s ");
    builder.append(this.radioId);
    builder.append(" -S UP -v circle -c black ");
    builder.append(" -x ");
    builder.append((int) loc.getX());
    builder.append(" -y ");
    builder.append((int) loc.getY());
    builder.append(" -Z 0 -z 20 ");

    return builder.toString();
  }

}
