package brn.sim.data.javis;

import jist.swans.Constants;

/**
 * A trace event representing a receive event: receive of a packet at the final destination.
 */
public class ReceiveTraceEvent extends TraceEvent {

  //private Integer radioId;
  private long sourceID;

  private long destinationID;

  private short packetType;

  private int sizeOfPacket;

  private int packetAttribute = 0; //used as color id

  private int packetID;

  public void set(long time, long SrcID, long destID, short pcktType,
      int sizeOfPacket, int pcktID) {
    this.sourceID = SrcID;
    this.destinationID = destID;
    this.packetType = pcktType;
    this.sizeOfPacket = sizeOfPacket;
    this.packetID = pcktID;
    this.time = time;
  }

  public String showYourself() {
    StringBuilder builder = new StringBuilder();

    builder.append("r -t ");
    builder.append(time / (float) Constants.SECOND);
    //builder.append( "n -t " + "*" + " ");
    builder.append(" -s ");
    builder.append(this.sourceID);
    builder.append(" -d ");
    builder.append(this.destinationID);
    builder.append(" -p ");
    builder.append(getProtocolName(this.packetType));
    builder.append(" -e ");
    builder.append(this.sizeOfPacket);
    builder.append(" -i ");
    builder.append(this.packetID);
    //builder.append("-c " + "2 ");
    builder.append(" -a ");
    builder.append(this.packetAttribute);

    return builder.toString();
  }

}
