/*
 * Created on 20/10/2005
 * @author Gabi Kliot
 */

package brn.sim.data.javis;

import jist.swans.Constants;

/**
 * Abstract class representing a single event of the gui trace.
 */
public abstract class TraceEvent {

  protected long time;

  public String getProtocolName(int pid) {
    if (pid == Constants.NET_PROTOCOL_AODV) {
      return "aodv";
      //return "message";
    } else if (pid == Constants.NET_PROTOCOL_DSR) {
      return "dsr";
    } else if (pid == Constants.NET_PROTOCOL_INVALID) {
      return "INVALID TYPE";
    } else if (pid == Constants.NET_PROTOCOL_TCP) {
      return "tcp";
    } else if (pid == Constants.NET_PROTOCOL_UDP) {
      return "udp";
      //return "message";
    } else if (pid == Constants.NET_PROTOCOL_ZRP) {
      return "zrp";
    } else if (pid == Constants.NET_PROTOCOL_HEARTBEAT) {
      return "heartbeat";
    } else if (pid == Constants.NET_PROTOCOL_BELLMANFORD) {
      return "BF";
    } else {
      return null;
    }
  }

  /**
   * To be implemented by an actual event, according to
   * the syntax of the trace event
   * (in case of Javis trace - accoirding to NAM syntax)
   */
  public abstract String showYourself();
}
