package brn.sim.handler;


import java.io.IOException;

import brn.sim.data.javis.Trace;
import brn.sim.data.javis.TraceEvent;

/**
 * Base class for all JavisEventHandlers; e.g. net, route, radio, mac
 */
abstract class JavisEventHandler {
  /** trace object for this Network Interface. */
  protected Trace trace;

  public JavisEventHandler(Trace trace) {
    this.trace = trace;
  }

  public Trace getTrace() {
    return trace;
  }

  abstract void registerHandlers();

  // ////////////////////////////////////////////////
  // accessors
  //

  protected void handleTrace(TraceEvent event) {

    try {
      trace.handleEvent(event);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
}
