package brn.sim.handler;

import brn.sim.data.javis.NodeTraceEvent;
import brn.sim.data.javis.Trace;
import jist.swans.misc.Event;
import jist.swans.field.AbstractField;

/**
 * Caputures only node positions (field model).
 */
public class JavisFieldEventHandler extends JavisEventHandler {

  // ////////////////////////////////////////////////
  // locals
  //
  public static final String TRACE_CHANNEL_EVENT_NAME = "channel";

  protected NodeTraceEvent nodeTraceEvent         = new NodeTraceEvent();

  // ////////////////////////////////////////////////
  // initialization
  //

  public JavisFieldEventHandler(Trace trace) {
    super(trace);
  }

  public void registerHandlers() {
    Event.addHandler(AbstractField.NodeMoveEvent.class, new NodeHandler());

//    Event.addHandler(LinkTraceEvent.class, this);
  }

  protected class NodeHandler implements Event.Handler {
    public void handle(Event event) {
      AbstractField.NodeMoveEvent ev = (AbstractField.NodeMoveEvent) event;

      nodeTraceEvent.set(ev.time, ev.loc, ev.info.getId());
      handleTrace(nodeTraceEvent);
    }
  }
}
