package brn.sim.handler;

import brn.sim.DataManager;
import brn.sim.data.TimeBar;
import jist.swans.misc.Event;
import jist.swans.mac.AbstractMac;
import jist.swans.mac.MacDcf;
import jist.swans.Constants;

import java.util.Hashtable;

public class TimeBarRadioStateHandler extends DataManager.DataContributor {

  // ////////////////////////////////////////////////
  // constants
  //

  private static final String ID = "TimeBarRadioStateHandler";

  // ////////////////////////////////////////////////
  // locals
  //

  private TimeBar radioTimeBar;

  private Hashtable lastEventTime = new Hashtable();


  // ////////////////////////////////////////////////
  // initialization
  //

  public TimeBarRadioStateHandler() {
    radioTimeBar = new TimeBar(new String[] {"Global", "Radio", "State Timebar"});
  }

  public void registerHandlers() {
    Event.addHandler(AbstractMac.RadioModeChanged.class, new Event.Handler() {
      public void handle(Event event) {
        AbstractMac.RadioModeChanged ev = (AbstractMac.RadioModeChanged) event;


        Object lastTime = lastEventTime.get(new Integer(ev.nodeId));
        if (lastTime == null) {
          lastEventTime.put(new Integer(ev.nodeId), new Long(0));
          lastTime = lastEventTime.get(new Integer(ev.nodeId));
        }

        long lastTimeL = ((Long)lastTime).longValue();

        byte color = -1;
        switch (ev.oldMode) {
          case Constants.RADIO_MODE_SLEEP:
            /** sleeping */
            color = TimeBar.COLOR_GRAY;
            break;
          case Constants.RADIO_MODE_SENSING:
            /** sensing */
            color = TimeBar.COLOR_BLUE;
            break;
          case Constants.RADIO_MODE_RECEIVING:
            /** receiving */
            color = TimeBar.COLOR_YELLOW;
            break;
          case Constants.RADIO_MODE_TRANSMITTING:
            /** transmitting */
            color = TimeBar.COLOR_GREEN;
            break;
          case Constants.RADIO_MODE_IDLE:
            break;
          default:
              // skip
            color = TimeBar.COLOR_BLUE;
        }

        if (color != -1) {
          int node = ev.nodeId;
        
          if (ev.internalNode != -1) {
            node *= 10;
            node += ev.internalNode;
          }
        
          radioTimeBar.add(node, lastTimeL, ev.time, color, MacDcf.getRadioModeString((byte)ev.oldMode));
        }
        lastEventTime.put(new Integer(ev.nodeId), new Long(ev.time));
      }
    });

  }


  // ////////////////////////////////////////////////
  // implementation
  //

  /**
   * @return the radioTimeBar
   */
  public TimeBar getRadioTimeBar() {
    return radioTimeBar;
  }

  /*
   * (non-Javadoc)
   * @see brn.sim.DataManager.DataContributor#getId()
   */
  public String getId() {
    return TimeBarRadioStateHandler.ID;
  }

  /* (non-Javadoc)
   * @see brn.sim.DataManager.DataContributor#setDataManager(brn.sim.DataManager)
   */
  public void setDataManager(DataManager manager) {
    super.setDataManager(manager);
    manager.addData(this, radioTimeBar);
  }

}
