package brn.sim.handler.gantt;

import brn.sim.data.gantt.Trace;
import brn.sim.data.gantt.TraceEvent;

import java.io.IOException;

/**
 * Base class for all GANTT event handler classes.
 */
public abstract class GanttEventHandler {

  /** trace object for this Network Interface. */
  protected Trace trace;

  public GanttEventHandler(Trace trace) {
    this.trace = trace;
  }

  public Trace getTrace() {
    return trace;
  }

  abstract void registerHandlers();

  // ////////////////////////////////////////////////
  // accessors
  //

  protected void handleTrace(TraceEvent event) {

    try {
      trace.handleEvent(event);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
}
